/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry.worldgen;

import com.github.alexthe666.rats.server.world.CopyInputStateRuleProcessor;
import com.github.alexthe666.rats.server.world.MarblePileFeature;
import com.github.alexthe666.rats.server.world.RatlantisRuinConfiguration;
import com.github.alexthe666.rats.server.world.RatlantisRuinFeature;
import com.github.alexthe666.rats.server.world.RatsCaveCarver;
import com.github.alexthe666.rats.server.world.ThickBranchingTrunkPlacer;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RatlantisFeatureRegistry {
    public static final DeferredRegister<WorldCarver<?>> CARVERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_CARVERS, (String)"rats");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"rats");
    public static final DeferredRegister<StructureProcessorType<?>> PROCESSORS = DeferredRegister.create((ResourceKey)Registries.f_256983_, (String)"rats");
    public static final DeferredRegister<TrunkPlacerType<?>> TRUNK_PLACERS = DeferredRegister.create((ResourceKey)Registries.f_256963_, (String)"rats");
    public static final RegistryObject<WorldCarver<CaveCarverConfiguration>> RATLANTIS_CAVES = CARVERS.register("ratlantis_caves", () -> new RatsCaveCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.f_159154_));
    public static final RegistryObject<Feature<RatlantisRuinConfiguration>> RATLANTIS_RUIN = FEATURES.register("ratlantis_ruin", () -> new RatlantisRuinFeature(RatlantisRuinConfiguration.CODEC));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> MARBLE_PILE = FEATURES.register("marble_pile", () -> new MarblePileFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<StructureProcessorType<CopyInputStateRuleProcessor>> COPY_STATE = RatlantisFeatureRegistry.registerProcessor("copy_state", () -> () -> CopyInputStateRuleProcessor.CODEC);
    public static final RegistryObject<TrunkPlacerType<ThickBranchingTrunkPlacer>> THICK_BASE_BRANCHING_TRUNK_PLACER = TRUNK_PLACERS.register("thick_branching_trunk_placer", () -> new TrunkPlacerType(ThickBranchingTrunkPlacer.CODEC));

    private static <P extends StructureProcessor> RegistryObject<StructureProcessorType<P>> registerProcessor(String name, Supplier<StructureProcessorType<P>> factory) {
        return PROCESSORS.register(name, factory);
    }
}

