/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.CubeModel;
import com.github.alexthe666.rats.client.model.RatsModelLayers;
import com.github.alexthe666.rats.server.entity.projectile.ThrownBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;

public class ThrownBlockRenderer
extends EntityRenderer<ThrownBlock> {
    private static final ResourceLocation LIGHTNING_TEXTURE = new ResourceLocation("rats", "textures/entity/psychic.png");
    private final CubeModel<ThrownBlock> cube;

    public ThrownBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.cube = new CubeModel(context.m_174023_(RatsModelLayers.THROWN_BLOCK));
        this.f_114477_ = 0.5f;
    }

    public void render(ThrownBlock entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        float f = (float)entity.f_19797_ + partialTicks;
        float yaw = entity.f_19859_ + (entity.m_146908_() - entity.f_19859_) * partialTicks;
        stack.m_85836_();
        BlockState state = entity.getHeldBlockState();
        if (state != null) {
            BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
            stack.m_85836_();
            stack.m_85837_(-0.5, 0.0, 0.5);
            stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            blockrendererdispatcher.m_110912_(state, stack, buffer, light, OverlayTexture.f_118083_);
            stack.m_85849_();
        }
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85841_(1.0f, -1.0f, 1.0f);
        stack.m_252880_(0.0f, -0.5f, 0.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_(yaw - 180.0f));
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110436_((ResourceLocation)LIGHTNING_TEXTURE, (float)(f * 0.01f), (float)(f * 0.01f)));
        this.cube.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, buffer, light);
    }

    public ResourceLocation getTextureLocation(ThrownBlock entity) {
        return InventoryMenu.f_39692_;
    }
}

