/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.server.inventory.AutoCurdlerMenu;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class AutoCurdlerScreen
extends AbstractContainerScreen<AutoCurdlerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats", "textures/gui/container/auto_curdler.png");
    private final AutoCurdlerMenu curdler;

    public AutoCurdlerScreen(AutoCurdlerMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.curdler = container;
    }

    public static void renderFluidStack(PoseStack stack, int xPosition, int yPosition, int desiredWidth, int desiredHeight, Fluid fluid) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int xTileCount = desiredWidth / 16;
        int xRemainder = desiredWidth - xTileCount * 16;
        int yTileCount = desiredHeight / 16;
        int yRemainder = desiredHeight - yTileCount * 16;
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        RenderSystem.enableBlend();
        BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : 16;
            if (width == 0) break;
            int x = xPosition + xTile * 16;
            int maskRight = 16 - width;
            int shiftedX = x + 16 - maskRight;
            float uLocalDif = uDif * (float)maskRight / 16.0f;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : 16;
                if (height == 0) continue block0;
                int y = yPosition - (yTile + 1) * 16;
                int maskTop = 16 - height;
                float vLocalDif = vDif * (float)maskTop / 16.0f;
                vertexBuffer.m_252986_(matrix4f, (float)x, (float)(y + 16), 0.0f).m_7421_(uMin + uLocalDif, vMax).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)shiftedX, (float)(y + 16), 0.0f).m_7421_(uMax, vMax).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)shiftedX, (float)(y + maskTop), 0.0f).m_7421_(uMax, vMin + vLocalDif).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)x, (float)(y + maskTop), 0.0f).m_7421_(uMin + uLocalDif, vMin + vLocalDif).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexBuffer.m_231175_());
        RenderSystem.disableBlend();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int l = this.curdler.getCookProgressionScaled();
        graphics.m_280218_(TEXTURE, i + 63, j + 35, 176, 0, l + 1, 16);
        int tankWidth = 24;
        int tankHeight = 63;
        int amount = Math.round((float)this.curdler.getFluidAmount() / (float)this.curdler.getTankCapacity() * (float)(tankHeight - 4));
        AutoCurdlerScreen.renderFluidStack(graphics.m_280168_(), i + 29, j + 73, tankWidth, amount, (Fluid)ForgeMod.MILK.get());
        graphics.m_280218_(TEXTURE, i + 29, j + 12, 0, 166, tankWidth, tankHeight);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        int screenW = (this.f_96543_ - this.f_97726_) / 2;
        int screenH = (this.f_96544_ - this.f_97727_) / 2;
        if (this.m_6774_(29, 15, 24, 58, mouseX, mouseY)) {
            String fluidName = new FluidStack((Fluid)ForgeMod.MILK.get(), this.curdler.getTankCapacity()).getDisplayName().getString();
            String fluidSize = this.curdler.getFluidAmount() + " " + Component.m_237115_((String)"container.rats.auto_curdler.mb").getString();
            List<Component> list = Arrays.asList(Component.m_237113_((String)fluidName).m_130940_(ChatFormatting.BLUE), Component.m_237113_((String)fluidSize).m_130940_(ChatFormatting.GRAY));
            graphics.m_280245_(this.f_96547_, Lists.transform(list, Component::m_7532_), mouseX - screenW, mouseY - screenH);
        }
    }
}

