/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dimension_access_manager.elements.commands.dimension;

import com.mojang.authlib.GameProfile;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.ModCapabilitiesRegisterFactory;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list.DimensionAccessListCapability;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list.dimension_access_blacklist.DimensionAccessBlacklistCapability;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list.dimension_access_whitelist.DimensionAccessWhitelistCapability;
import de.geheimagentnr1.minecraft_forge_api.util.ResourceLocationHelper;
import java.util.Collection;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.NotNull;

class DimensionCommandPlayersHelper {
    DimensionCommandPlayersHelper() {
    }

    @NotNull
    private static String gameProfilesToString(@NotNull TreeSet<GameProfile> gameProfiles) {
        return DimensionCommandPlayersHelper.gameProfilesToString(gameProfiles.stream());
    }

    @NotNull
    private static String gameProfilesToString(@NotNull Stream<GameProfile> gameProfiles) {
        return gameProfiles.map(GameProfile::getName).collect(Collectors.joining(", "));
    }

    @NotNull
    private static Stream<GameProfile> addTargetsToList(@NotNull DimensionAccessListCapability dimensionAccessListCapability, @NotNull Collection<GameProfile> gameProfiles) {
        return gameProfiles.stream().filter(dimensionAccessListCapability::add);
    }

    @NotNull
    private static Stream<GameProfile> removeTargetsFromList(@NotNull DimensionAccessListCapability dimensionAccessListCapability, @NotNull Collection<GameProfile> gameProfiles) {
        return gameProfiles.stream().filter(dimensionAccessListCapability::remove);
    }

    static void runForWhitelist(@NotNull ServerLevel serverLevel, @NotNull NonNullConsumer<DimensionAccessWhitelistCapability> runner) {
        serverLevel.getCapability(ModCapabilitiesRegisterFactory.DIMENSION_ACCESS_WHITELIST).ifPresent(runner);
    }

    static void sendWhitelistList(@NotNull DimensionAccessWhitelistCapability dimensionAccessWhitelistCapability, @NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel) {
        String gameProfiles = DimensionCommandPlayersHelper.gameProfilesToString(dimensionAccessWhitelistCapability.getGameProfiles());
        if (gameProfiles.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)String.format("Whitelist \"%s\" is empty.", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel))), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)String.format("Whitelist \"%s\": %s", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), gameProfiles)), false);
        }
    }

    static void addTargetsToWhitelist(@NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel, @NotNull Collection<GameProfile> gameProfiles) {
        DimensionCommandPlayersHelper.runForWhitelist(serverLevel, (NonNullConsumer<DimensionAccessWhitelistCapability>)((NonNullConsumer)dimensionAccessWhitelistCapability -> source.m_288197_(() -> Component.m_237113_((String)String.format("Added to dimension \"%s\" whitelist: %s", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), DimensionCommandPlayersHelper.gameProfilesToString(DimensionCommandPlayersHelper.addTargetsToList(dimensionAccessWhitelistCapability, gameProfiles)))), true)));
    }

    static void removeTargetsFromWhitelist(@NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel, @NotNull Collection<GameProfile> gameProfiles) {
        DimensionCommandPlayersHelper.runForWhitelist(serverLevel, (NonNullConsumer<DimensionAccessWhitelistCapability>)((NonNullConsumer)dimensionAccessWhitelistCapability -> source.m_288197_(() -> Component.m_237113_((String)String.format("Removed from dimension \"%s\" whitelist: %s", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), DimensionCommandPlayersHelper.gameProfilesToString(DimensionCommandPlayersHelper.removeTargetsFromList(dimensionAccessWhitelistCapability, gameProfiles)))), true)));
    }

    static void runForBlacklist(@NotNull ServerLevel serverLevel, @NotNull NonNullConsumer<DimensionAccessBlacklistCapability> runner) {
        serverLevel.getCapability(ModCapabilitiesRegisterFactory.DIMENSION_ACCESS_BLACKLIST).ifPresent(runner);
    }

    static void sendBlacklistList(@NotNull DimensionAccessBlacklistCapability dimensionAccessBlacklistCapability, @NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel) {
        String gameProfiles = DimensionCommandPlayersHelper.gameProfilesToString(dimensionAccessBlacklistCapability.getGameProfiles());
        if (gameProfiles.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)String.format("Blacklist \"%s\" is empty.", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel))), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)String.format("Blacklist \"%s\": %s", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), gameProfiles)), false);
        }
    }

    static void addTargetsToBlacklist(@NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel, @NotNull Collection<GameProfile> gameProfiles) {
        DimensionCommandPlayersHelper.runForBlacklist(serverLevel, (NonNullConsumer<DimensionAccessBlacklistCapability>)((NonNullConsumer)dimensionAccessBlacklistCapability -> source.m_288197_(() -> Component.m_237113_((String)String.format("Added to dimension \"%s\" blacklist: %s", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), DimensionCommandPlayersHelper.gameProfilesToString(DimensionCommandPlayersHelper.addTargetsToList(dimensionAccessBlacklistCapability, gameProfiles)))), true)));
    }

    static void removeTargetsFromBlacklist(@NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel, @NotNull Collection<GameProfile> gameProfiles) {
        DimensionCommandPlayersHelper.runForBlacklist(serverLevel, (NonNullConsumer<DimensionAccessBlacklistCapability>)((NonNullConsumer)dimensionAccessBlacklistCapability -> source.m_288197_(() -> Component.m_237113_((String)String.format("Removed from dimension \"%s\" blacklist: %s", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), DimensionCommandPlayersHelper.gameProfilesToString(DimensionCommandPlayersHelper.removeTargetsFromList(dimensionAccessBlacklistCapability, gameProfiles)))), true)));
    }
}

