/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dimension_access_manager.elements.commands.dimension;

import de.geheimagentnr1.dimension_access_manager.elements.capabilities.ModCapabilitiesRegisterFactory;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access.DimensionAccessCapability;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access.DimensionAccessType;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list.DimensionAccessListCapability;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list.dimension_access_blacklist.DimensionAccessBlacklistCapability;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list.dimension_access_whitelist.DimensionAccessWhitelistCapability;
import de.geheimagentnr1.dimension_access_manager.elements.commands.dimension.DimensionCommandPlayersHelper;
import de.geheimagentnr1.minecraft_forge_api.util.ResourceLocationHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.NotNull;

public class DimensionCommandAccessHelper {
    static void runForAccess(@NotNull ServerLevel serverLevel, @NotNull NonNullConsumer<DimensionAccessCapability> runner) {
        serverLevel.getCapability(ModCapabilitiesRegisterFactory.DIMENSION_ACCESS).ifPresent(runner);
    }

    public static void showDimensionStatus(@NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel) {
        DimensionCommandAccessHelper.runForAccess(serverLevel, (NonNullConsumer<DimensionAccessCapability>)((NonNullConsumer)dimensionAccessCapability -> {
            if (dimensionAccessCapability.getDimensionAccess() == DimensionAccessType.GRANTED) {
                DimensionCommandPlayersHelper.runForBlacklist(serverLevel, (NonNullConsumer<DimensionAccessBlacklistCapability>)((NonNullConsumer)dimensionAccessBlacklistCapability -> DimensionCommandAccessHelper.sendDimensionStatusFeedback(source, serverLevel, DimensionAccessType.GRANTED, DimensionCommandAccessHelper.isListed(source, dimensionAccessBlacklistCapability))));
            } else {
                DimensionCommandPlayersHelper.runForWhitelist(serverLevel, (NonNullConsumer<DimensionAccessWhitelistCapability>)((NonNullConsumer)dimensionAccessWhitelistCapability -> DimensionCommandAccessHelper.sendDimensionStatusFeedback(source, serverLevel, DimensionAccessType.LOCKED, DimensionCommandAccessHelper.isListed(source, dimensionAccessWhitelistCapability))));
            }
        }));
    }

    private static boolean isListed(@NotNull CommandSourceStack source, @NotNull DimensionAccessListCapability dimensionAccessListCapability) {
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            return dimensionAccessListCapability.contains(((ServerPlayer)entity).m_36316_());
        }
        return false;
    }

    private static void sendDimensionStatusFeedback(@NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel, @NotNull DimensionAccessType dimensionStatus, boolean isListed) {
        if (isListed) {
            source.m_288197_(() -> Component.m_237113_((String)String.format("\"%s\": Access is %s. For you %s", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), dimensionStatus.m_7912_(), (dimensionStatus == DimensionAccessType.GRANTED ? DimensionAccessType.LOCKED : DimensionAccessType.GRANTED).m_7912_())), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)String.format("\"%s\": Access is %s.", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), dimensionStatus.m_7912_())), false);
        }
    }

    static void sendDimensionAccessChangedFeedback(@NotNull CommandSourceStack source, @NotNull ServerLevel serverLevel, @NotNull DimensionAccessCapability dimensionAccessCapability) {
        source.m_288197_(() -> Component.m_237113_((String)String.format("%s is now %s.", ResourceLocationHelper.serverLevelToName((ServerLevel)serverLevel), dimensionAccessCapability.getDimensionAccess().m_7912_())), true);
    }
}

