/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dimension_access_manager.elements.commands.dimension;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.dimension_access_manager.config.ServerConfig;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access.DimensionAccessCapability;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access.DimensionAccessType;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list.dimension_access_blacklist.DimensionAccessBlacklistCapability;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list.dimension_access_whitelist.DimensionAccessWhitelistCapability;
import de.geheimagentnr1.dimension_access_manager.elements.commands.dimension.DimensionCommandAccessHelper;
import de.geheimagentnr1.dimension_access_manager.elements.commands.dimension.DimensionCommandPlayersHelper;
import de.geheimagentnr1.dimension_access_manager.elements.commands.dimension.DimensionCommandRunner;
import de.geheimagentnr1.minecraft_forge_api.elements.commands.CommandInterface;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.NotNull;

public class DimensionCommand
implements CommandInterface {
    @NotNull
    private final ServerConfig serverConfig;

    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        Predicate<CommandSourceStack> permissionChecker = source -> source.m_6761_(this.serverConfig.getDimensionCommandPermissionLevel().intValue());
        LiteralArgumentBuilder dimension = Commands.m_82127_((String)"dimension");
        dimension.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"access").then(Commands.m_82127_((String)"status").executes(this::showDimensionStatus))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"grant").requires(permissionChecker)).executes(this::grantDimension))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"lock").requires(permissionChecker)).executes(this::lockDimension)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"players").requires(permissionChecker)).then(Commands.m_82127_((String)"list").executes(this::showLists))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"whitelist").then(Commands.m_82127_((String)"list").executes(this::showWhitelist))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).executes(this::addTargetsToWhitelist)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).executes(this::removeTargetsFromWhitelist))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"blacklist").then(Commands.m_82127_((String)"list").executes(this::showBlacklist))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).executes(this::addTargetsToBlacklist)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).executes(this::removeTargetsFromBlacklist))))));
        return dimension;
    }

    private int showDimensionStatus(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> DimensionCommandAccessHelper.showDimensionStatus(source, serverLevel));
        return 1;
    }

    private int grantDimension(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> DimensionCommandAccessHelper.runForAccess(serverLevel, (NonNullConsumer<DimensionAccessCapability>)((NonNullConsumer)dimensionAccessCapability -> {
            dimensionAccessCapability.setDimensionAccess(DimensionAccessType.GRANTED);
            DimensionCommandAccessHelper.sendDimensionAccessChangedFeedback(source, serverLevel, dimensionAccessCapability);
            this.saveChanges(serverLevel);
        })));
        return 1;
    }

    private int lockDimension(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> DimensionCommandAccessHelper.runForAccess(serverLevel, (NonNullConsumer<DimensionAccessCapability>)((NonNullConsumer)dimensionAccessCapability -> {
            dimensionAccessCapability.setDimensionAccess(DimensionAccessType.LOCKED);
            DimensionCommandAccessHelper.sendDimensionAccessChangedFeedback(source, serverLevel, dimensionAccessCapability);
            this.saveChanges(serverLevel);
        })));
        return 1;
    }

    private int showLists(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> {
            DimensionCommandPlayersHelper.runForWhitelist(serverLevel, (NonNullConsumer<DimensionAccessWhitelistCapability>)((NonNullConsumer)dimensionAccessWhitelistCapability -> DimensionCommandPlayersHelper.sendWhitelistList(dimensionAccessWhitelistCapability, source, serverLevel)));
            DimensionCommandPlayersHelper.runForBlacklist(serverLevel, (NonNullConsumer<DimensionAccessBlacklistCapability>)((NonNullConsumer)dimensionAccessBlacklistCapability -> DimensionCommandPlayersHelper.sendBlacklistList(dimensionAccessBlacklistCapability, source, serverLevel)));
        });
        return 1;
    }

    private int showWhitelist(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> DimensionCommandPlayersHelper.runForWhitelist(serverLevel, (NonNullConsumer<DimensionAccessWhitelistCapability>)((NonNullConsumer)dimensionAccessWhitelistCapability -> DimensionCommandPlayersHelper.sendWhitelistList(dimensionAccessWhitelistCapability, source, serverLevel))));
        return 1;
    }

    private int addTargetsToWhitelist(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Collection gameProfiles = GameProfileArgument.m_94590_(commandContext, (String)"targets");
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> {
            DimensionCommandPlayersHelper.removeTargetsFromBlacklist(source, serverLevel, gameProfiles);
            DimensionCommandPlayersHelper.addTargetsToWhitelist(source, serverLevel, gameProfiles);
            this.saveChanges(serverLevel);
        });
        return gameProfiles.size();
    }

    private int removeTargetsFromWhitelist(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Collection gameProfiles = GameProfileArgument.m_94590_(commandContext, (String)"targets");
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> {
            DimensionCommandPlayersHelper.removeTargetsFromWhitelist(source, serverLevel, gameProfiles);
            this.saveChanges(serverLevel);
        });
        return gameProfiles.size();
    }

    private int showBlacklist(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> DimensionCommandPlayersHelper.runForBlacklist(serverLevel, (NonNullConsumer<DimensionAccessBlacklistCapability>)((NonNullConsumer)dimensionAccessBlacklistCapability -> DimensionCommandPlayersHelper.sendBlacklistList(dimensionAccessBlacklistCapability, source, serverLevel))));
        return 1;
    }

    private int addTargetsToBlacklist(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Collection gameProfiles = GameProfileArgument.m_94590_(commandContext, (String)"targets");
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> {
            DimensionCommandPlayersHelper.removeTargetsFromWhitelist(source, serverLevel, gameProfiles);
            DimensionCommandPlayersHelper.addTargetsToBlacklist(source, serverLevel, gameProfiles);
            this.saveChanges(serverLevel);
        });
        return gameProfiles.size();
    }

    private int removeTargetsFromBlacklist(@NotNull CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Collection gameProfiles = GameProfileArgument.m_94590_(commandContext, (String)"targets");
        DimensionCommandRunner.run(commandContext, (context, source, serverLevel) -> {
            DimensionCommandPlayersHelper.removeTargetsFromBlacklist(source, serverLevel, gameProfiles);
            this.saveChanges(serverLevel);
        });
        return gameProfiles.size();
    }

    private void saveChanges(@NotNull ServerLevel serverLevel) {
        serverLevel.m_8643_(null, false, false);
    }

    public DimensionCommand(@NotNull ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
    }
}

