/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators.TYGTreeDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class AttachedToLogsDecorator
extends TreeDecorator {
    public static final Codec<AttachedToLogsDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(attachedToLogsDecorator -> Float.valueOf(attachedToLogsDecorator.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.exclusionRadiusY), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.blockProvider), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.requiredEmptyBlocks), (App)ExtraCodecs.m_144637_((Codec)Direction.f_175356_.listOf()).fieldOf("directions").forGetter(attachedToLogsDecorator -> attachedToLogsDecorator.directions)).apply((Applicative)builder, AttachedToLogsDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int exclusionRadiusY;
    protected final BlockStateProvider blockProvider;
    protected final int requiredEmptyBlocks;
    protected final List<Direction> directions;

    public AttachedToLogsDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, BlockStateProvider blockProvider, int requiredEmptyBlocks, List<Direction> directions) {
        this.probability = probability;
        this.exclusionRadiusXZ = exclusionRadiusXZ;
        this.exclusionRadiusY = exclusionRadiusY;
        this.blockProvider = blockProvider;
        this.requiredEmptyBlocks = requiredEmptyBlocks;
        this.directions = directions;
    }

    public void m_214187_(TreeDecorator.Context pContext) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        RandomSource randomsource = pContext.m_226067_();
        for (BlockPos blockpos : Util.m_214611_((ObjectArrayList)pContext.m_226068_(), (RandomSource)randomsource)) {
            Direction direction;
            BlockPos relative = blockpos.m_121945_(direction = (Direction)Util.m_214621_(this.directions, (RandomSource)randomsource));
            if (set.contains(relative) || !(randomsource.m_188501_() < this.probability) || !this.hasRequiredEmptyBlocks(pContext, blockpos, direction)) continue;
            BlockPos offsetMin = relative.m_7918_(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPos offsetMax = relative.m_7918_(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPos blockpos4 : BlockPos.m_121940_((BlockPos)offsetMin, (BlockPos)offsetMax)) {
                set.add(blockpos4.m_7949_());
            }
            BlockState state = this.blockProvider.m_213972_(randomsource, relative);
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction);
            }
            pContext.m_226061_(relative, state);
        }
    }

    private boolean hasRequiredEmptyBlocks(TreeDecorator.Context pContext, BlockPos pPos, Direction pDirection) {
        for (int i = 1; i <= this.requiredEmptyBlocks; ++i) {
            BlockPos blockpos = pPos.m_5484_(pDirection, i);
            if (pContext.m_226059_(blockpos)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        return TYGTreeDecoratorTypes.ATTACHED_TO_LOGS.get();
    }
}

