/*
 * Decompiled with CFR 0.152.
 */
package chummycho.tabular.server;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TabularConfigServer {
    public static ForgeConfigSpec CONFIG_SPEC;
    public static TabularConfigServer CONFIG;
    public static final int MIN_TABS = 1;
    public final ForgeConfigSpec.IntValue numberOfTabs;

    public static void init() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TabularConfigServer::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (TabularConfigServer)specPair.getLeft();
    }

    TabularConfigServer(ForgeConfigSpec.Builder builder) {
        this.numberOfTabs = builder.comment("The number of extra inventory tabs.").defineInRange("tabCount", 3, 1, Integer.MAX_VALUE);
    }

    public static int getNumberOfTabs() {
        return Math.max(1, (Integer)TabularConfigServer.CONFIG.numberOfTabs.get());
    }

    public static void setNumberOfTabs(int nrOfTabs) {
        int clamped = Math.max(1, nrOfTabs);
        TabularConfigServer.CONFIG.numberOfTabs.set((Object)clamped);
        TabularConfigServer.CONFIG.numberOfTabs.save();
    }
}

