/*
 * Decompiled with CFR 0.152.
 */
package chummycho.tabular.client;

import chummycho.tabular.client.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TabularConfigClient {
    public static ForgeConfigSpec CONFIG_SPEC;
    public static TabularConfigClient CONFIG;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> tabNames;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> screensBlacklist;
    public final ForgeConfigSpec.ConfigValue<Boolean> showScreenNames;

    public static void init() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TabularConfigClient::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (TabularConfigClient)specPair.getLeft();
    }

    TabularConfigClient(ForgeConfigSpec.Builder builder) {
        List<String> defaultTabNames = Util.listOf("minecraft:grass_block", "minecraft:iron_sword", "minecraft:gold_ingot", "minecraft:apple", "minecraft:totem_of_undying", "Tab 5", "Tab 6", "Tab 7", "Tab 8");
        this.tabNames = builder.comment("The names of the tabs.").defineList("tabNames", defaultTabNames, str -> true);
        this.screensBlacklist = builder.comment("The names of the screens that tabs should NOT be rendered in.").defineList("screensBlacklist", Util.listOf(new String[0]), str -> true);
        this.showScreenNames = builder.comment("Show the names of the opened screens in chat.").define("showScreenNames", false);
    }

    public static List<String> getTabNames() {
        return (List)TabularConfigClient.CONFIG.tabNames.get();
    }

    public static void setTabName(int nr, String newName) {
        try {
            ArrayList<String> list = (ArrayList<String>)TabularConfigClient.CONFIG.tabNames.get();
            if (nr >= list.size()) {
                ArrayList<String> newlist = new ArrayList<String>(Collections.nCopies(nr + 1, ""));
                Collections.copy(newlist, list);
                list = newlist;
            }
            list.set(nr, newName);
            TabularConfigClient.CONFIG.tabNames.set((Object)list);
            TabularConfigClient.CONFIG.tabNames.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> getBlacklistedScreens() {
        return (List)TabularConfigClient.CONFIG.screensBlacklist.get();
    }

    public static boolean isShowScreenNames() {
        return (Boolean)TabularConfigClient.CONFIG.showScreenNames.get();
    }

    public static void setShowScreenNames(boolean val) {
        TabularConfigClient.CONFIG.showScreenNames.set((Object)val);
    }

    public static void addScreenName(String screenName) {
        try {
            List blacklist = (List)TabularConfigClient.CONFIG.screensBlacklist.get();
            if (!blacklist.contains(screenName)) {
                blacklist.add(screenName);
                TabularConfigClient.CONFIG.screensBlacklist.set((Object)blacklist);
                TabularConfigClient.CONFIG.screensBlacklist.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeScreenName(String screenName) {
        try {
            List blacklist = (List)TabularConfigClient.CONFIG.screensBlacklist.get();
            if (blacklist.contains(screenName)) {
                blacklist.remove(screenName);
                TabularConfigClient.CONFIG.screensBlacklist.set((Object)blacklist);
                TabularConfigClient.CONFIG.screensBlacklist.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

