/*
 * Decompiled with CFR 0.152.
 */
package chummycho.tabular.client;

import chummycho.tabular.TabCounts;
import chummycho.tabular.TabsCapability;
import chummycho.tabular.client.TabButton;
import chummycho.tabular.client.TabularConfigClient;
import chummycho.tabular.net.Net;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    private static final Minecraft mc = Minecraft.m_91087_();

    @SubscribeEvent
    public static void onInitScreenPost(ScreenEvent.Init.Post event) {
        LocalPlayer player = ClientEvents.mc.f_91074_;
        if (player == null) {
            return;
        }
        String screenName = event.getScreen().getClass().getSimpleName();
        List<String> blacklistedScreens = TabularConfigClient.getBlacklistedScreens();
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (TabularConfigClient.isShowScreenNames()) {
                player.m_213846_((Component)Component.m_237115_((String)screenName));
            }
            if (blacklistedScreens == null || !blacklistedScreens.contains(screenName)) {
                TabsCapability.get((Player)player).ifPresent(cap -> {
                    List<String> tabNames = TabularConfigClient.getTabNames();
                    int nrOfTabs = TabCounts.getClientTabCount();
                    cap.update();
                    if (cap.getCurrentTab() >= nrOfTabs) {
                        cap.setCurrentTab(0);
                        Net.sendToggleMessageToServer(0);
                    }
                    TabButton[] buttons = new TabButton[nrOfTabs];
                    for (int i = 0; i < nrOfTabs; ++i) {
                        int tabNr = i;
                        String tabName = i < tabNames.size() ? tabNames.get(i) : "Tab " + tabNr;
                        int w = screen2.getXSize() / nrOfTabs;
                        int dy = screenName.equals("CreativeModeInventoryScreen") ? 24 : 0;
                        buttons[i] = new TabButton(screen2.getGuiLeft() + tabNr * w, screen2.getGuiTop() + screen2.getYSize() + dy, w, 20, tabName, button -> {
                            if (!buttons[tabNr].f_93623_) {
                                return;
                            }
                            Net.sendToggleMessageToServer(tabNr);
                            buttons[cap.getCurrentTab()].f_93623_ = true;
                            buttons[tabNr].f_93623_ = false;
                            cap.setCurrentTab(tabNr);
                        });
                        if (i == cap.getCurrentTab()) {
                            buttons[i].f_93623_ = false;
                        }
                        event.addListener((GuiEventListener)buttons[i]);
                    }
                });
            }
        }
    }

    public static void switchToTab(byte tab) {
        LocalPlayer player = ClientEvents.mc.f_91074_;
        TabsCapability.get((Player)player).ifPresent(cap -> TabsCapability.switchToTab((Player)player, tab));
    }

    public static void setNumberOfTabs(int nrOfTabs) {
        TabCounts.updateClientTabCount(nrOfTabs);
        TabsCapability.get((Player)ClientEvents.mc.f_91074_).ifPresent(TabsCapability::update);
    }
}

