/*
 * Decompiled with CFR 0.152.
 */
package chummycho.tabular;

import chummycho.tabular.TabsCapability;
import chummycho.tabular.client.TabularConfigClient;
import chummycho.tabular.net.Net;
import chummycho.tabular.server.TabularConfigServer;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TabularCommands {
    private static Predicate<CommandSourceStack> OP = source -> source.m_6761_(2);
    public static final Command<CommandSourceStack> setNumberOfTabs = context -> {
        int requested = (Integer)context.getArgument("numberOfTab", Integer.class);
        int oldCount = TabularConfigServer.getNumberOfTabs();
        int newCount = Math.max(1, requested);
        if (newCount == oldCount) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Tab count unchanged (" + newCount + ").")));
            return 0;
        }
        if (newCount < oldCount) {
            for (ServerPlayer serverPlayer : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
                TabsCapability.get((Player)serverPlayer).ifPresent(cap -> {
                    List<ItemStack> stacks = cap.collectTabsBeyond(newCount);
                    TabularCommands.dropStacks(serverPlayer, stacks);
                });
            }
        }
        TabularConfigServer.setNumberOfTabs(newCount);
        for (ServerPlayer serverplayer : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            Net.sendNumberOfTabs(serverplayer, newCount);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Tab count set to " + newCount)), true);
        return newCount;
    };
    public static final Command<CommandSourceStack> addTab = context -> {
        int nr = TabularConfigServer.getNumberOfTabs() + 1;
        TabularConfigServer.setNumberOfTabs(nr);
        for (ServerPlayer serverplayer : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            Net.sendNumberOfTabs(serverplayer, nr);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Added tab " + nr)), true);
        return 1;
    };
    public static final Command<CommandSourceStack> showScreenNames = context -> {
        boolean nr = (Boolean)context.getArgument("showScreenNames", Boolean.class);
        TabularConfigClient.setShowScreenNames(nr);
        return 1;
    };
    public static final Command<CommandSourceStack> addScreenName = context -> {
        String screenName = (String)context.getArgument("screenName", String.class);
        TabularConfigClient.addScreenName(screenName);
        return 1;
    };
    public static final Command<CommandSourceStack> removeScreenName = context -> {
        String screenName = (String)context.getArgument("screenName", String.class);
        TabularConfigClient.removeScreenName(screenName);
        return 1;
    };

    @SubscribeEvent
    public static void init(RegisterCommandsEvent event) {
        CommandDispatcher d = event.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tabular").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setNumberOfTabs").requires(OP)).then(Commands.m_82129_((String)"numberOfTab", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(setNumberOfTabs)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"addTab").requires(OP)).executes(addTab))).then(Commands.m_82127_((String)"setShowScreenNames").then(Commands.m_82129_((String)"showScreenNames", (ArgumentType)BoolArgumentType.bool()).executes(showScreenNames)))).then(Commands.m_82127_((String)"addScreenName").then(Commands.m_82129_((String)"screenName", (ArgumentType)StringArgumentType.word()).executes(addScreenName)))).then(Commands.m_82127_((String)"removeScreenName").then(Commands.m_82129_((String)"screenName", (ArgumentType)StringArgumentType.word()).executes(removeScreenName))));
    }

    private static void dropStacks(ServerPlayer player, List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        Vec3 pos = player.m_20182_();
        for (ItemStack stack : stacks) {
            ItemStack drop = stack.m_41777_();
            ItemEntity itemEntity = new ItemEntity(player.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, drop);
            player.m_9236_().m_7967_((Entity)itemEntity);
        }
    }
}

