/*
 * Decompiled with CFR 0.152.
 */
package chummycho.tabular;

import chummycho.tabular.TabCounts;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabsCapability {
    public static final Capability<TabsCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<TabsCapability>(){});
    private static final int INV_SIZE = 27;
    private final IntSupplier tabCountSupplier;
    private int currTab = 0;
    private ItemStackHandler[] tabs;
    private final Map<Item, Integer> itemSortMap = Maps.newHashMap();

    public TabsCapability() {
        this(TabCounts::getServerTabCount);
    }

    public TabsCapability(IntSupplier tabCountSupplier) {
        this.tabCountSupplier = tabCountSupplier;
        this.initializeTabs(this.getExpectedTabCount());
    }

    private void initializeTabs(int numberOfTabs) {
        this.tabs = new ItemStackHandler[numberOfTabs];
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i] = new ItemStackHandler(27);
        }
    }

    public int getCurrentTab() {
        return this.currTab;
    }

    public void setCurrentTab(int tabNr) {
        this.currTab = tabNr;
    }

    public Map<Item, Integer> getItemSortMap() {
        return this.itemSortMap;
    }

    public static LazyOptional<TabsCapability> get(Player player) {
        if (player == null) {
            return LazyOptional.empty();
        }
        return player.getCapability(CAPABILITY);
    }

    public void update() {
        int number = this.getExpectedTabCount();
        if (number != this.tabs.length) {
            ItemStackHandler[] newTabs = new ItemStackHandler[number];
            for (int i = 0; i < number; ++i) {
                newTabs[i] = i < this.tabs.length ? this.tabs[i] : new ItemStackHandler(27);
            }
            this.tabs = newTabs;
        }
        if (!this.isValidTab(this.currTab)) {
            this.currTab = 0;
        }
    }

    private int getExpectedTabCount() {
        return Math.max(1, this.tabCountSupplier.getAsInt());
    }

    public void updateItemSort() {
        this.itemSortMap.clear();
        for (int i = 0; i < this.tabs.length; ++i) {
            for (int j = 0; j < this.tabs[i].getSlots(); ++j) {
                ItemStack itemStack = this.tabs[i].getStackInSlot(j);
                if (itemStack.m_41619_()) continue;
                this.itemSortMap.put(itemStack.m_41720_(), i);
            }
        }
    }

    public ItemStackHandler getTab(int i) {
        this.update();
        if (this.isValidTab(i)) {
            return this.tabs[i];
        }
        return null;
    }

    public void saveInvToCurrTab(IItemHandler inv) {
        this.update();
        if (!this.isValidTab(this.currTab)) {
            return;
        }
        for (int i = 0; i < 27; ++i) {
            ItemStack extracted = inv.extractItem(this.slotIndex(i), 64, false);
            this.tabs[this.currTab].setStackInSlot(i, extracted);
        }
    }

    boolean loadTabIntoInventory(int tabNr, IItemHandler inv) {
        int i;
        this.update();
        if (!this.isValidTab(tabNr)) {
            return false;
        }
        ItemStack[] tabContents = new ItemStack[27];
        for (int i2 = 0; i2 < 27; ++i2) {
            tabContents[i2] = this.tabs[tabNr].getStackInSlot(i2).m_41777_();
        }
        ItemStack[] inserted = new ItemStack[27];
        for (i = 0; i < 27; ++i) {
            ItemStack stack = tabContents[i];
            if (stack.m_41619_()) {
                inserted[i] = ItemStack.f_41583_;
                continue;
            }
            ItemStack remainder = inv.insertItem(this.slotIndex(i), stack.m_41777_(), false);
            if (!remainder.m_41619_()) {
                this.revertInsertion(inv, inserted, i);
                return false;
            }
            inserted[i] = stack;
        }
        for (i = 0; i < 27; ++i) {
            this.tabs[tabNr].setStackInSlot(i, ItemStack.f_41583_);
        }
        return true;
    }

    private void revertInsertion(IItemHandler inv, ItemStack[] inserted, int lastInsertedIndex) {
        for (int i = 0; i <= lastInsertedIndex; ++i) {
            ItemStack stack = inserted[i];
            if (stack == null || stack.m_41619_()) continue;
            inv.extractItem(this.slotIndex(i), stack.m_41613_(), false);
        }
    }

    private int slotIndex(int tabSlot) {
        return tabSlot + 9;
    }

    public static void switchToTab(Player player, int tabNr) {
        TabsCapability.get(player).ifPresent(cap -> {
            if (!cap.isValidTab(tabNr)) {
                return;
            }
            player.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHand -> {
                cap.update();
                int previousTab = cap.currTab;
                cap.saveInvToCurrTab((IItemHandler)itemHand);
                if (cap.loadTabIntoInventory(tabNr, (IItemHandler)itemHand)) {
                    cap.currTab = tabNr;
                } else {
                    cap.loadTabIntoInventory(previousTab, (IItemHandler)itemHand);
                }
            });
        });
    }

    private boolean isValidTab(int tabNr) {
        return tabNr >= 0 && tabNr < this.tabs.length;
    }

    public List<ItemStackHandler> getAllOtherTabs() {
        LinkedList<ItemStackHandler> otherTabsList = new LinkedList<ItemStackHandler>();
        for (int i = 0; i < this.tabs.length; ++i) {
            if (i == this.currTab) continue;
            otherTabsList.add(this.tabs[i]);
        }
        return otherTabsList;
    }

    public int resolveTabForItem(Item item) {
        Integer mapped = this.itemSortMap.get(item);
        if (mapped != null && this.isValidTab(mapped)) {
            return mapped;
        }
        return this.currTab;
    }

    public ItemStack insertIntoTab(int tabIndex, ItemStack stack) {
        ItemStackHandler handler = this.getTab(tabIndex);
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        ItemStack remainder = stack.m_41777_();
        for (int i = 0; i < handler.getSlots() && !remainder.m_41619_(); ++i) {
            remainder = handler.insertItem(i, remainder, false);
        }
        if (remainder.m_41613_() != stack.m_41613_()) {
            this.rememberItemTab(stack.m_41720_(), tabIndex);
        }
        return remainder;
    }

    public void rememberItemTab(Item item, int tabIndex) {
        if (this.isValidTab(tabIndex)) {
            this.itemSortMap.put(item, tabIndex);
        }
    }

    public void cloneFrom(TabsCapability prev) {
        this.currTab = prev.currTab;
        this.tabs = prev.tabs;
    }

    public List<ItemStack> collectTabsBeyond(int keepCount) {
        this.update();
        int safeKeep = Math.max(0, Math.min(keepCount, this.tabs.length));
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        for (int tabIndex = safeKeep; tabIndex < this.tabs.length; ++tabIndex) {
            ItemStackHandler handler = this.tabs[tabIndex];
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.m_41619_()) continue;
                dropped.add(stack.m_41777_());
                handler.setStackInSlot(slot, ItemStack.f_41583_);
            }
        }
        if (this.currTab >= safeKeep) {
            this.currTab = 0;
        }
        return dropped;
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final TabsCapability capability;
        private final LazyOptional<TabsCapability> capProvider;

        public Provider(Player player) {
            IntSupplier supplier = player.m_9236_().m_5776_() ? TabCounts::getClientTabCount : TabCounts::getServerTabCount;
            this.capability = new TabsCapability(supplier);
            this.capProvider = LazyOptional.of(() -> this.capability);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == CAPABILITY ? this.capProvider.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("currTab", this.capability.currTab);
            for (int i = 0; i < this.capability.tabs.length; ++i) {
                tag.m_128365_("tab" + i, (Tag)this.capability.tabs[i].serializeNBT());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.capability.update();
            this.capability.currTab = nbt.m_128451_("currTab");
            for (int i = 0; i < this.capability.tabs.length; ++i) {
                Tag tabTag = nbt.m_128423_("tab" + i);
                if (!(tabTag instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)tabTag;
                this.capability.tabs[i].deserializeNBT(compoundTag);
            }
        }
    }
}

