/*
 * Decompiled with CFR 0.152.
 */
package chummycho.tabular;

import chummycho.tabular.TabsCapability;
import chummycho.tabular.net.Net;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.register(TabsCapability.class);
    }

    @SubscribeEvent
    public static void attachToPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(new ResourceLocation("tabular", "tabs"), (ICapabilityProvider)new TabsCapability.Provider(player));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LazyOptional<TabsCapability> Capability2 = TabsCapability.get((Player)serverPlayer);
            Capability2.ifPresent(cap -> Net.sendToggleMessageToClient(serverPlayer, cap.getCurrentTab()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntity().m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                TabsCapability.get(player).ifPresent(cap -> {
                    for (ItemStackHandler handler : cap.getAllOtherTabs()) {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            Vec3 pos = player.m_20182_();
                            ItemStack stack = handler.getStackInSlot(i);
                            ItemEntity ent = new ItemEntity(player.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
                            event.getDrops().add(ent);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player originalPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        if (!event.isWasDeath() || newPlayer.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            TabsCapability.get(newPlayer).ifPresent(newCap -> {
                originalPlayer.reviveCaps();
                TabsCapability.get(originalPlayer).ifPresent(newCap::cloneFrom);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TabsCapability.get((Player)serverPlayer).ifPresent(cap -> Net.sendToggleMessageToClient(serverPlayer, cap.getCurrentTab()));
        }
    }
}

