/*
 * Decompiled with CFR 0.152.
 */
package chummycho.tabular;

import chummycho.tabular.TabsCapability;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AutoPickupEvent {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ItemEntity itemEntity = event.getItem();
        ItemStack stack = itemEntity.m_32055_();
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (level.m_5776_() || stack.m_41619_() || player.m_5833_()) {
            return;
        }
        TabsCapability.get(player).ifPresent(cap -> {
            int inserted;
            cap.updateItemSort();
            int targetTab = cap.resolveTabForItem(stack.m_41720_());
            int original = stack.m_41613_();
            ItemStack remainder = stack.m_41777_();
            IItemHandler inv = (IItemHandler)player.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            if (inv != null) {
                int s;
                for (s = 0; s < 9 && !remainder.m_41619_(); ++s) {
                    if (inv.getStackInSlot(s).m_41619_()) continue;
                    remainder = inv.insertItem(s, remainder, false);
                }
                for (s = 9; s < 36 && !remainder.m_41619_(); ++s) {
                    if (inv.getStackInSlot(s).m_41619_()) continue;
                    remainder = inv.insertItem(s, remainder, false);
                }
                for (s = 0; s < 9 && !remainder.m_41619_(); ++s) {
                    if (!inv.getStackInSlot(s).m_41619_()) continue;
                    remainder = inv.insertItem(s, remainder, false);
                }
                for (s = 9; s < 36 && !remainder.m_41619_(); ++s) {
                    if (!inv.getStackInSlot(s).m_41619_()) continue;
                    remainder = inv.insertItem(s, remainder, false);
                }
                if (targetTab == cap.getCurrentTab() && remainder.m_41613_() < original) {
                    cap.rememberItemTab(stack.m_41720_(), targetTab);
                }
            }
            if (!remainder.m_41619_() && targetTab != cap.getCurrentTab()) {
                remainder = cap.insertIntoTab(targetTab, remainder);
            }
            if ((inserted = original - remainder.m_41613_()) > 0) {
                player.m_7938_((Entity)itemEntity, inserted);
                if (remainder.m_41619_()) {
                    itemEntity.m_146870_();
                    event.setCanceled(true);
                } else {
                    itemEntity.m_32045_(remainder);
                }
            }
        });
    }
}

