/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.helpers;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import java.lang.reflect.Method;
import net.minecraft.world.entity.player.Player;

public class BlueSkiesHelper {
    private static final Class<?> SKIES_PLAYER;
    private static final Class<?> SKIES_PLAYER_INTERFACE;
    private static final Method SET_HEALTH;
    private static final Method GET_HEALTH;
    private static final Method GET_CAPABILITY;
    private static final boolean MOD_PRESENT;

    public static void maybeFixCapability(Player player) {
        if (!MOD_PRESENT) {
            return;
        }
        try {
            Float health;
            Object maybeHealth;
            Object capability = GET_CAPABILITY.invoke(null, player);
            if (capability != null && (maybeHealth = GET_HEALTH.invoke(capability, new Object[0])) instanceof Float && (health = (Float)maybeHealth).isNaN()) {
                SET_HEALTH.invoke(capability, Float.valueOf(0.0f));
                player.m_21153_(0.0f);
                EnigmaticLegacy.LOGGER.info("Fixed NaN natural health for player: " + player.m_36316_().getName());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        Method getCapability;
        Method getHealth;
        Method setHealth;
        Class<?> iface;
        Class<?> player;
        try {
            player = Class.forName("com.legacy.blue_skies.capability.SkiesPlayer");
            iface = Class.forName("com.legacy.blue_skies.capability.util.ISkiesPlayer");
            setHealth = iface.getMethod("setNatureHealth", Float.TYPE);
            getHealth = iface.getMethod("getNatureHealth", new Class[0]);
            getCapability = player.getMethod("get", Player.class);
        }
        catch (Throwable ex) {
            player = null;
            iface = null;
            setHealth = null;
            getHealth = null;
            getCapability = null;
        }
        SKIES_PLAYER = player;
        SKIES_PLAYER_INTERFACE = iface;
        SET_HEALTH = setHealth;
        GET_HEALTH = getHealth;
        GET_CAPABILITY = getCapability;
        MOD_PRESENT = player != null && iface != null;
        EnigmaticLegacy.LOGGER.info("Blue Skies detected: " + MOD_PRESENT);
    }
}

