/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.foundation.ponder.instruction;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlockEntity;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import java.util.ArrayList;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ConveyChainRotationsInstruction
extends PonderInstruction {
    private final BlockPos chainStartLocation;
    private final float rpm;

    public ConveyChainRotationsInstruction(BlockPos chainStartLocation, float rpm) {
        this.chainStartLocation = chainStartLocation;
        this.rpm = rpm;
    }

    public boolean isComplete() {
        return true;
    }

    public void tick(PonderScene scene) {
        BlockEntity chainStartBlockEntity = scene.getWorld().m_7702_(this.chainStartLocation);
        if (chainStartBlockEntity instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity cogwheelChainBlockEntity = (CogwheelChainBlockEntity)chainStartBlockEntity;
            if (cogwheelChainBlockEntity.isController()) {
                this.conveyRotationsFromController(cogwheelChainBlockEntity, this.rpm);
            } else {
                Vec3i offset = cogwheelChainBlockEntity.getControllerOffset();
                if (offset == null) {
                    CreateBitsnBobs.LOGGER.warn("Could not convey rotations for ponder chain block entity at {} as it had no controller offset set", (Object)this.chainStartLocation);
                    return;
                }
                BlockPos controllerPos = this.chainStartLocation.m_121955_(offset);
                BlockEntity controllerBlockEntity = scene.getWorld().m_7702_(controllerPos);
                if (controllerBlockEntity instanceof CogwheelChainBlockEntity) {
                    CogwheelChainBlockEntity controllerCogwheelChainBlockEntity = (CogwheelChainBlockEntity)controllerBlockEntity;
                    this.conveyRotationsFromController(controllerCogwheelChainBlockEntity, this.rpm);
                }
            }
        }
    }

    private void conveyRotationsFromController(CogwheelChainBlockEntity controllerChainBlockEntity, float rpm) {
        BlockPos chainControllerPos = controllerChainBlockEntity.m_58899_();
        float initialChainRotationFactor = controllerChainBlockEntity.getChainRotationFactor();
        CogwheelChain chain = controllerChainBlockEntity.getChain();
        if (chain == null) {
            CreateBitsnBobs.LOGGER.warn("Ponder block entities chain was null despite it being a controller, ignoring instruction");
            return;
        }
        Level level = controllerChainBlockEntity.m_58904_();
        for (PathedCogwheelNode chainNode : new ArrayList<PathedCogwheelNode>(chain.getChainPathCogwheelNodes())) {
            BlockEntity blockEntity;
            BlockPos nodePos = chainControllerPos.m_121955_((Vec3i)chainNode.localPos());
            if (chainNode.localPos() == Vec3i.f_123288_ || !((blockEntity = controllerChainBlockEntity.m_58904_().m_7702_(nodePos)) instanceof CogwheelChainBlockEntity)) continue;
            CogwheelChainBlockEntity childCogwheelChainBlockEntity = (CogwheelChainBlockEntity)blockEntity;
            this.modifyBlockEntityKineticRotation(level, childCogwheelChainBlockEntity, initialChainRotationFactor, childCogwheelChainBlockEntity.getChainRotationFactor(), rpm);
        }
        this.modifyBlockEntityKineticRotation(level, controllerChainBlockEntity, -1.0f, initialChainRotationFactor, rpm);
    }

    private void modifyBlockEntityKineticRotation(Level level, CogwheelChainBlockEntity childCogwheelChainBlockEntity, float initialFactor, float factor, float rpm) {
        CompoundTag tag = childCogwheelChainBlockEntity.m_187480_();
        tag.m_128350_("Speed", rpm * initialFactor / factor);
        childCogwheelChainBlockEntity.m_142466_(tag);
    }

    public void reset(PonderScene scene) {
        super.reset(scene);
    }
}

