/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.weathered_girder;

import com.kipti.bnb.content.weathered_girder.WeatheredGirderEncasedShaftBlock;
import com.kipti.bnb.content.weathered_girder.WeatheredGirderPlacementHelper;
import com.kipti.bnb.content.weathered_girder.WeatheredGirderWrenchBehaviour;
import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.content.decoration.girder.GirderEncasedShaftBlock;
import com.simibubi.create.content.decoration.placard.PlacardBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlock;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WeatheredGirderBlock
extends GirderBlock {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new WeatheredGirderPlacementHelper());

    public WeatheredGirderBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (AllBlocks.SHAFT.isIn(itemInHand)) {
            KineticBlockEntity.switchToBlockState((Level)pLevel, (BlockPos)pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)BnbBlocks.WEATHERED_METAL_GIRDER_ENCASED_SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)))).m_61124_((Property)TOP, (Comparable)((Boolean)pState.m_61143_((Property)TOP)))).m_61124_((Property)BOTTOM, (Comparable)((Boolean)pState.m_61143_((Property)BOTTOM)))).m_61124_(GirderEncasedShaftBlock.HORIZONTAL_AXIS, (Comparable)((Boolean)pState.m_61143_((Property)X) != false || pHit.m_82434_().m_122434_() == Direction.Axis.Z ? Direction.Axis.Z : Direction.Axis.X))));
            pLevel.m_5594_(null, pPos, SoundEvents.f_12201_, SoundSource.BLOCKS, 0.5f, 1.25f);
            if (!pLevel.f_46443_ && !pPlayer.m_7500_()) {
                itemInHand.m_41774_(1);
                if (itemInHand.m_41619_()) {
                    pPlayer.m_21008_(pHand, ItemStack.f_41583_);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (AllItems.WRENCH.isIn(itemInHand) && !pPlayer.m_6144_()) {
            if (WeatheredGirderWrenchBehaviour.handleClick(pLevel, pPos, pState, pHit)) {
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(itemInHand)) {
            return helper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)itemInHand.m_41720_(), pPlayer, pHand, pHit);
        }
        return InteractionResult.PASS;
    }

    public static boolean isConnected(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        Direction.Axis axis = side.m_122434_();
        if (state.m_60734_() instanceof WeatheredGirderBlock && !((Boolean)state.m_61143_((Property)(axis == Direction.Axis.X ? X : Z))).booleanValue()) {
            return false;
        }
        if (state.m_60734_() instanceof WeatheredGirderEncasedShaftBlock && state.m_61143_(WeatheredGirderEncasedShaftBlock.HORIZONTAL_AXIS) == axis) {
            return false;
        }
        BlockPos relative = pos.m_121945_(side);
        BlockState blockState = world.m_8055_(relative);
        if (blockState.m_60795_()) {
            return false;
        }
        if (blockState.m_60734_() instanceof NixieTubeBlock && NixieTubeBlock.getFacing((BlockState)blockState) == side) {
            return true;
        }
        if (WeatheredGirderBlock.isFacingBracket((BlockAndTintGetter)world, (BlockPos)pos, (Direction)side)) {
            return true;
        }
        if (blockState.m_60734_() instanceof PlacardBlock && PlacardBlock.connectedDirection((BlockState)blockState) == side) {
            return true;
        }
        VoxelShape shape = blockState.m_60808_((BlockGetter)world, relative);
        if (shape.m_83281_()) {
            return false;
        }
        if (Block.m_49918_((VoxelShape)shape, (Direction)side.m_122424_()) && blockState.m_280296_()) {
            return true;
        }
        return AbstractChuteBlock.getChuteFacing((BlockState)blockState) == Direction.DOWN;
    }
}

