/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut.geometry;

import com.kipti.bnb.content.girder_strut.geometry.GirderVertex;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class GirderGeometry {
    public static final float EPSILON = 1.0E-4f;
    public static final int DEFAULT_COLOR = -1;
    public static final int DEFAULT_LIGHT = LightTexture.m_109885_((int)15, (int)15);

    public static float signedDistance(Vector3f point, Vector3f planeNormal, Vector3f planePoint) {
        return new Vector3f((Vector3fc)point).sub((Vector3fc)planePoint).dot((Vector3fc)planeNormal);
    }

    public static GirderVertex interpolate(GirderVertex start, GirderVertex end, float t) {
        Vector3f position = new Vector3f((Vector3fc)start.position()).lerp((Vector3fc)end.position(), t);
        Vector3f normal = new Vector3f((Vector3fc)start.normal()).lerp((Vector3fc)end.normal(), t);
        if (normal.lengthSquared() > 1.0E-4f) {
            normal.normalize();
        }
        float u = Mth.m_14179_((float)t, (float)start.u(), (float)end.u());
        float v = Mth.m_14179_((float)t, (float)start.v(), (float)end.v());
        int color = GirderGeometry.lerpColor(start.color(), end.color(), t);
        int light = start.light();
        return new GirderVertex(position, normal, u, v, color, light);
    }

    public static int lerpColor(int a, int b, float t) {
        if (a == b) {
            return a;
        }
        int aA = a >>> 24 & 0xFF;
        int aR = a >>> 16 & 0xFF;
        int aG = a >>> 8 & 0xFF;
        int aB = a & 0xFF;
        int bA = b >>> 24 & 0xFF;
        int bR = b >>> 16 & 0xFF;
        int bG = b >>> 8 & 0xFF;
        int bB = b & 0xFF;
        int alpha = (int)Mth.m_14036_((float)Mth.m_14179_((float)t, (float)aA, (float)bA), (float)0.0f, (float)255.0f);
        int red = (int)Mth.m_14036_((float)Mth.m_14179_((float)t, (float)aR, (float)bR), (float)0.0f, (float)255.0f);
        int green = (int)Mth.m_14036_((float)Mth.m_14179_((float)t, (float)aG, (float)bG), (float)0.0f, (float)255.0f);
        int blue = (int)Mth.m_14036_((float)Mth.m_14179_((float)t, (float)aB, (float)bB), (float)0.0f, (float)255.0f);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int lerpPackedLight(int a, int b, float t) {
        int blockA = a & 0xFFFF;
        int skyA = a >>> 16 & 0xFFFF;
        int blockB = b & 0xFFFF;
        int skyB = b >>> 16 & 0xFFFF;
        int block = (int)Mth.m_14036_((float)Mth.m_14179_((float)t, (float)blockA, (float)blockB), (float)0.0f, (float)65535.0f);
        int sky = (int)Mth.m_14036_((float)Mth.m_14179_((float)t, (float)skyA, (float)skyB), (float)0.0f, (float)65535.0f);
        return sky << 16 | block;
    }

    public static boolean positionsEqual(Vector3f a, Vector3f b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        float dz = a.z - b.z;
        return dx * dx + dy * dy + dz * dz <= 9.999999E-9f;
    }

    public static List<GirderVertex> dedupeLoopVertices(List<GirderVertex> vertices) {
        ArrayList<GirderVertex> cleaned = new ArrayList<GirderVertex>(vertices.size());
        for (GirderVertex vertex : vertices) {
            if (!cleaned.isEmpty() && GirderGeometry.positionsEqual(((GirderVertex)cleaned.get(cleaned.size() - 1)).position(), vertex.position())) continue;
            cleaned.add(vertex);
        }
        if (cleaned.size() >= 2 && GirderGeometry.positionsEqual(((GirderVertex)cleaned.get(0)).position(), ((GirderVertex)cleaned.get(cleaned.size() - 1)).position())) {
            cleaned.remove(cleaned.size() - 1);
        }
        return cleaned;
    }

    public static Vector3f computePolygonNormal(List<GirderVertex> vertices) {
        Vector3f normal = new Vector3f();
        int size = vertices.size();
        for (int i = 0; i < vertices.size(); ++i) {
            Vector3f current = vertices.get(i).position();
            Vector3f next = vertices.get((i + 1) % size).position();
            normal.x += (current.y - next.y) * (current.z + next.z);
            normal.y += (current.z - next.z) * (current.x + next.x);
            normal.z += (current.x - next.x) * (current.y + next.y);
        }
        return normal.normalize();
    }

    public static void emitPolygon(List<GirderVertex> vertices, TextureAtlasSprite sprite, Direction faceOverride, int tintIndex, boolean shade, List<BakedQuad> consumer) {
        if (vertices.size() == 4) {
            consumer.add(GirderGeometry.buildQuad(vertices, sprite, faceOverride, tintIndex, shade));
            return;
        }
        if (vertices.size() == 3) {
            consumer.add(GirderGeometry.buildQuad(Arrays.asList(vertices.get(0), vertices.get(1), vertices.get(2), vertices.get(2)), sprite, faceOverride, tintIndex, shade));
            return;
        }
        GirderVertex anchor = vertices.get(0);
        for (int i = 1; i < vertices.size() - 1; ++i) {
            List<GirderVertex> tri = Arrays.asList(anchor, vertices.get(i), vertices.get(i + 1), vertices.get(i + 1));
            consumer.add(GirderGeometry.buildQuad(tri, sprite, faceOverride, tintIndex, shade));
        }
    }

    private static BakedQuad buildQuad(List<GirderVertex> quadVertices, TextureAtlasSprite sprite, Direction faceOverride, int tintIndex, boolean shade) {
        int stride = BakedQuadHelper.VERTEX_STRIDE;
        int[] vertexData = new int[stride * 4];
        for (int i = 0; i < quadVertices.size(); ++i) {
            GirderVertex vertex = quadVertices.get(i);
            Vec3 pos = new Vec3((double)vertex.position().x, (double)vertex.position().y, (double)vertex.position().z);
            Vec3 normal = new Vec3((double)vertex.normal().x, (double)vertex.normal().y, (double)vertex.normal().z);
            BakedQuadHelper.setXYZ((int[])vertexData, (int)i, (Vec3)pos);
            BakedQuadHelper.setNormalXYZ((int[])vertexData, (int)i, (Vec3)normal);
            BakedQuadHelper.setU((int[])vertexData, (int)i, (float)vertex.u());
            BakedQuadHelper.setV((int[])vertexData, (int)i, (float)vertex.v());
            int baseIndex = i * stride;
            vertexData[baseIndex + 3] = vertex.color();
            vertexData[baseIndex + 6] = vertex.light();
        }
        Vector3f avgNormal = GirderGeometry.computePolygonNormal(quadVertices);
        Direction face = faceOverride;
        if (avgNormal.lengthSquared() > 1.0E-4f) {
            avgNormal.normalize();
            face = Math.abs(avgNormal.y) > 1.0E-4f ? (avgNormal.y < 0.0f ? Direction.DOWN : Direction.UP) : Direction.m_122372_((float)avgNormal.x, (float)avgNormal.y, (float)avgNormal.z);
        }
        return new BakedQuad(vertexData, tintIndex, face, sprite, shade);
    }

    public static float remapU(float originalU, TextureAtlasSprite from, TextureAtlasSprite to) {
        float fromSpan = from.m_118410_() - from.m_118409_();
        float toSpan = to.m_118410_() - to.m_118409_();
        if (Math.abs(fromSpan) <= 1.0E-4f || Math.abs(toSpan) <= 1.0E-4f) {
            return to.m_118409_();
        }
        return (originalU - from.m_118409_()) / fromSpan * toSpan + to.m_118409_();
    }

    public static float remapV(float originalV, TextureAtlasSprite from, TextureAtlasSprite to) {
        float fromSpan = from.m_118412_() - from.m_118411_();
        float toSpan = to.m_118412_() - to.m_118411_();
        if (Math.abs(fromSpan) <= 1.0E-4f || Math.abs(toSpan) <= 1.0E-4f) {
            return to.m_118411_();
        }
        return (originalV - from.m_118411_()) / fromSpan * toSpan + to.m_118411_();
    }

    public static void emitPolygonToConsumer(List<GirderVertex> verticesToTestRelight, List<Consumer<BufferBuilder>> consumer, Function<Vector3f, Integer> lightFunction) {
        verticesToTestRelight = GirderGeometry.dedupeLoopVertices(verticesToTestRelight);
        Vector3f normal = GirderGeometry.computePolygonNormal(verticesToTestRelight);
        ArrayList<GirderVertex> vertices = new ArrayList<GirderVertex>();
        for (GirderVertex v : verticesToTestRelight) {
            vertices.add(new GirderVertex(v.position(), normal, v.u(), v.v(), -1, lightFunction.apply(v.position())));
        }
        if (vertices.size() == 4) {
            consumer.add(GirderGeometry.buildQuadConsumer(vertices));
            return;
        }
        if (vertices.size() == 3) {
            consumer.add(GirderGeometry.buildQuadConsumer(Arrays.asList((GirderVertex)vertices.get(0), (GirderVertex)vertices.get(1), (GirderVertex)vertices.get(2), (GirderVertex)vertices.get(2))));
            return;
        }
        GirderVertex anchor = (GirderVertex)vertices.get(0);
        for (int i = 1; i < vertices.size() - 1; ++i) {
            List<GirderVertex> tri = Arrays.asList(anchor, (GirderVertex)vertices.get(i), (GirderVertex)vertices.get(i + 1), (GirderVertex)vertices.get(i + 1));
            consumer.add(GirderGeometry.buildQuadConsumer(tri));
        }
    }

    private static Consumer<BufferBuilder> buildQuadConsumer(List<GirderVertex> tri) {
        return bufferBuilder -> {
            for (GirderVertex vertex : tri) {
                bufferBuilder.m_5483_((double)vertex.position().x, (double)vertex.position().y, (double)vertex.position().z).m_6122_(vertex.color() >> 16 & 0xFF, vertex.color() >> 8 & 0xFF, vertex.color() & 0xFF, vertex.color() >> 24 & 0xFF).m_7421_(vertex.u(), vertex.v()).m_86008_(OverlayTexture.f_118083_).m_85969_(vertex.light()).m_5601_(vertex.normal().x, vertex.normal().y, vertex.normal().z).m_5752_();
            }
        };
    }
}

