/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlock;
import com.kipti.bnb.content.girder_strut.GirderStrutBlockEntity;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class GirderStrutBlockItem
extends BlockItem {
    private static final double MAX_ANGLE_DEGREES = 75.0;
    private static final double MIN_DOT_THRESHOLD = Math.cos(Math.toRadians(75.0));

    public GirderStrutBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ConnectionResult result;
        Direction targetFace;
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction face = context.m_43719_();
        if (context.m_7078_()) {
            if (GirderStrutBlockItem.hasPlacement(stack)) {
                GirderStrutBlockItem.clearPlacement(stack);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
        BlockPos placementPos = this.resolvePlacementPos(level, clickedPos, face);
        Direction placementFace = face;
        if (placementPos != null && level.m_8055_(placementPos).m_60734_().equals(this.m_40614_())) {
            placementFace = (Direction)level.m_8055_(placementPos).m_61143_((Property)GirderStrutBlock.FACING);
        }
        if (!GirderStrutBlockItem.hasPlacement(stack)) {
            if (placementPos == null) {
                return InteractionResult.FAIL;
            }
            GirderStrutBlockItem.setPlacement(stack, placementPos, placementFace);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        Pair<BlockPos, Direction> fromData = GirderStrutBlockItem.getPlacement(stack);
        BlockPos fromPos = (BlockPos)fromData.getFirst();
        Direction fromFace = (Direction)fromData.getSecond();
        if (fromPos == null) {
            GirderStrutBlockItem.clearPlacement(stack);
            return InteractionResult.FAIL;
        }
        if (placementPos == null) {
            return InteractionResult.FAIL;
        }
        if (fromFace == null) {
            BlockState fromState = level.m_8055_(fromPos);
            fromFace = fromState.m_60734_().equals(this.m_40614_()) ? (Direction)fromState.m_61143_((Property)GirderStrutBlock.FACING) : placementFace.m_122424_();
        }
        if ((targetFace = placementFace) == null) {
            targetFace = Direction.UP;
        }
        if (!level.f_46443_ && (result = this.tryConnect(context, fromPos, fromFace, placementPos, targetFace)) != ConnectionResult.SUCCESS) {
            if (result == ConnectionResult.INVALID) {
                GirderStrutBlockItem.clearPlacement(stack);
            }
            return InteractionResult.FAIL;
        }
        GirderStrutBlockItem.clearPlacement(stack);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static boolean hasPlacement(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("GirderStrutFrom");
    }

    public static void clearPlacement(ItemStack stack) {
        stack.m_41749_("GirderStrutFrom");
        stack.m_41749_("GirderStrutFromFace");
    }

    public static Pair<BlockPos, Direction> getPlacement(ItemStack stack) {
        if (!stack.m_41782_() || !GirderStrutBlockItem.hasPlacement(stack)) {
            return Pair.of(null, null);
        }
        BlockPos fromPos = new BlockPos(NBTHelper.readVec3i((ListTag)stack.m_41784_().m_128437_("GirderStrutFrom", 3)));
        Direction fromFace = Direction.m_122402_((String)stack.m_41784_().m_128461_("GirderStrutFromFace"));
        if (fromFace == null) {
            fromFace = Direction.UP;
        }
        return Pair.of((Object)fromPos, (Object)fromFace);
    }

    public static void setPlacement(ItemStack stack, BlockPos fromPos, Direction fromFace) {
        stack.m_41784_().m_128365_("GirderStrutFrom", (Tag)NBTHelper.writeVec3i((Vec3i)fromPos));
        stack.m_41784_().m_128359_("GirderStrutFromFace", fromFace.m_122433_());
    }

    public boolean m_5812_(ItemStack stack) {
        return GirderStrutBlockItem.hasPlacement(stack) || super.m_5812_(stack);
    }

    public static boolean isValidConnection(Level level, BlockPos fromPos, Direction fromFace, BlockPos toPos, Direction toFace) {
        int diffZ;
        int diffY;
        if (fromPos == null || toPos == null || fromFace == null || toFace == null) {
            return false;
        }
        if (fromPos.equals((Object)toPos)) {
            return false;
        }
        int diffX = toPos.m_123341_() - fromPos.m_123341_();
        int nonZero = (diffX != 0 ? 1 : 0) + ((diffY = toPos.m_123342_() - fromPos.m_123342_()) != 0 ? 1 : 0) + ((diffZ = toPos.m_123343_() - fromPos.m_123343_()) != 0 ? 1 : 0);
        if (nonZero >= 3) {
            return false;
        }
        double lengthSq = diffX * diffX + diffY * diffY + diffZ * diffZ;
        if (lengthSq > 64.0) {
            return false;
        }
        Vec3 fromCenter = Vec3.m_82512_((Vec3i)fromPos);
        Vec3 toCenter = Vec3.m_82512_((Vec3i)toPos);
        Vec3 connection = toCenter.m_82546_(fromCenter);
        Vec3 reverseConnection = fromCenter.m_82546_(toCenter);
        if (!GirderStrutBlockItem.isWithinAngle(connection, fromFace)) {
            return false;
        }
        return GirderStrutBlockItem.isWithinAngle(reverseConnection, toFace);
    }

    private static boolean isWithinAngle(Vec3 vector, Direction face) {
        Vec3 faceNormal;
        if (vector.m_82556_() < 1.0E-6) {
            return false;
        }
        Vec3 unitVec = vector.m_82541_();
        double dot = unitVec.m_82526_(faceNormal = Vec3.m_82528_((Vec3i)face.m_122436_()).m_82541_());
        return dot >= MIN_DOT_THRESHOLD;
    }

    private ConnectionResult tryConnect(UseOnContext context, BlockPos fromPos, Direction fromFace, BlockPos targetPos, Direction targetFace) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (!GirderStrutBlockItem.isValidConnection(level, fromPos, fromFace, targetPos, targetFace)) {
            return ConnectionResult.INVALID;
        }
        BlockState fromState = level.m_8055_(fromPos);
        BlockState targetState = level.m_8055_(targetPos);
        boolean fromNeedsPlacement = !fromState.m_60734_().equals(this.m_40614_());
        boolean targetNeedsPlacement = !targetState.m_60734_().equals(this.m_40614_());
        int requiredAnchors = (fromNeedsPlacement ? 1 : 0) + (targetNeedsPlacement ? 1 : 0);
        if (fromNeedsPlacement && !this.canOccupy(level, fromPos)) {
            return ConnectionResult.INVALID;
        }
        if (targetNeedsPlacement && !this.canOccupy(level, targetPos)) {
            return ConnectionResult.INVALID;
        }
        if (player != null && !player.m_150110_().f_35937_ && !this.hasRequiredAnchors(player, stack, requiredAnchors)) {
            return ConnectionResult.MISSING_ITEMS;
        }
        int placedCount = 0;
        if (fromNeedsPlacement) {
            if (!this.placeAnchor(level, fromPos, fromFace, player, stack.m_41777_())) {
                return ConnectionResult.INVALID;
            }
            ++placedCount;
        } else if (fromState.m_61143_((Property)GirderStrutBlock.FACING) != fromFace) {
            level.m_7731_(fromPos, (BlockState)fromState.m_61124_((Property)GirderStrutBlock.FACING, (Comparable)fromFace), 3);
        }
        if (targetNeedsPlacement) {
            if (!this.placeAnchor(level, targetPos, targetFace, player, stack.m_41777_())) {
                if (fromNeedsPlacement) {
                    level.m_7471_(fromPos, false);
                }
                return ConnectionResult.INVALID;
            }
            ++placedCount;
        } else if (targetState.m_61143_((Property)GirderStrutBlock.FACING) != targetFace) {
            level.m_7731_(targetPos, (BlockState)targetState.m_61124_((Property)GirderStrutBlock.FACING, (Comparable)targetFace), 3);
        }
        BlockState newFromState = level.m_8055_(fromPos);
        BlockState newTargetState = level.m_8055_(targetPos);
        if (!newFromState.m_60734_().equals(this.m_40614_()) || !newTargetState.m_60734_().equals(this.m_40614_())) {
            return ConnectionResult.INVALID;
        }
        if (placedCount > 0) {
            this.consumeAnchors(player, stack, placedCount);
        }
        this.connect(level, fromPos, targetPos);
        return ConnectionResult.SUCCESS;
    }

    private void connect(Level level, BlockPos fromPos, BlockPos targetPos) {
        BlockEntity blockEntity = level.m_7702_(fromPos);
        if (!(blockEntity instanceof GirderStrutBlockEntity)) {
            return;
        }
        GirderStrutBlockEntity from = (GirderStrutBlockEntity)blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(targetPos);
        if (!(blockEntity2 instanceof GirderStrutBlockEntity)) {
            return;
        }
        GirderStrutBlockEntity target = (GirderStrutBlockEntity)blockEntity2;
        from.addConnection(targetPos);
        target.addConnection(fromPos);
        BlockState updatedFromState = level.m_8055_(fromPos);
        BlockState updatedTargetState = level.m_8055_(targetPos);
        level.m_7260_(fromPos, updatedFromState, updatedFromState, 3);
        level.m_7260_(targetPos, updatedTargetState, updatedTargetState, 3);
    }

    private boolean hasRequiredAnchors(Player player, ItemStack heldStack, int required) {
        if (required <= 0) {
            return true;
        }
        if (player == null) {
            return heldStack.m_41613_() >= required;
        }
        int available = this.countAnchors(player, heldStack);
        if (available < required) {
            this.notifyMissingAnchors(player, required - available);
            return false;
        }
        return true;
    }

    private void consumeAnchors(Player player, ItemStack heldStack, int amount) {
        if (amount <= 0 || player == null || player.m_150110_().f_35937_) {
            return;
        }
        int remaining = amount;
        remaining -= this.drainStack(heldStack, remaining);
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_() && remaining > 0; ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (slotStack == heldStack || !this.isMatchingStrut(slotStack, heldStack)) continue;
            remaining -= this.drainStack(slotStack, remaining);
        }
    }

    private int drainStack(ItemStack stack, int amount) {
        if (amount <= 0) {
            return 0;
        }
        int toRemove = Math.min(stack.m_41613_(), amount);
        if (toRemove > 0) {
            stack.m_41774_(toRemove);
        }
        return toRemove;
    }

    private int countAnchors(Player player, ItemStack reference) {
        Inventory inventory = player.m_150109_();
        int total = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (!this.isMatchingStrut(slotStack, reference)) continue;
            total += slotStack.m_41613_();
        }
        return total;
    }

    private boolean isMatchingStrut(ItemStack candidate, ItemStack reference) {
        return !candidate.m_41619_() && candidate.m_41720_() == reference.m_41720_();
    }

    private void notifyMissingAnchors(Player player, int missing) {
        if (missing <= 0) {
            return;
        }
        MutableComponent message = Component.m_237110_((String)"message.bits_n_bobs.girder_strut.missing_anchors", (Object[])new Object[]{missing}).m_130940_(ChatFormatting.RED);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_5661_((Component)message, true);
        } else {
            player.m_5661_((Component)message, true);
        }
    }

    private boolean placeAnchor(Level level, BlockPos pos, Direction face, Player player, ItemStack stackSnapshot) {
        BlockState newState = (BlockState)this.m_40614_().m_49966_().m_61124_((Property)GirderStrutBlock.FACING, (Comparable)face);
        if (!level.m_7731_(pos, newState, 3)) {
            return false;
        }
        Block block = newState.m_60734_();
        block.m_6402_(level, pos, newState, (LivingEntity)player, stackSnapshot);
        SoundType soundType = newState.m_60827_();
        level.m_5594_(player, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
        return true;
    }

    private boolean canOccupy(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_60734_().equals(this.m_40614_());
    }

    private BlockPos resolvePlacementPos(Level level, BlockPos clickedPos, Direction face) {
        BlockState clickedState = level.m_8055_(clickedPos);
        if (clickedState.m_60734_().equals(this.m_40614_())) {
            return clickedPos;
        }
        BlockPos pos = clickedPos.m_121945_(face);
        BlockState state = level.m_8055_(pos);
        if (!state.m_60795_() && !state.m_60734_().equals(this.m_40614_())) {
            return null;
        }
        return pos;
    }

    private static enum ConnectionResult {
        SUCCESS,
        INVALID,
        MISSING_ITEMS;

    }
}

