/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.item;

import com.kipti.bnb.content.cogwheel_chain.graph.ChainInteractionFailedException;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelChain;
import com.kipti.bnb.network.BnbPackets;
import com.kipti.bnb.network.packets.from_client.PlaceCogwheelChainPacket;
import com.kipti.bnb.registry.BnbFeatureFlag;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CogwheelChainPlacementInteraction {
    @Nullable
    protected static PlacingCogwheelChain currentBuildingChain = null;
    @Nullable
    protected static ResourceKey<Level> currentChainLevel = null;

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            return;
        }
        KeyMapping key = event.getKeyMapping();
        if (key == mc.f_91066_.f_92095_ && CogwheelChainPlacementInteraction.onRightClick(event)) {
            event.setCanceled(true);
        }
    }

    private static boolean onRightClick(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack itemInHand;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player == null || level == null) {
            return false;
        }
        Object object = player.m_21205_().m_150930_(Items.f_42026_) ? player.m_21205_() : (itemInHand = player.m_21206_().m_150930_(Items.f_42026_) ? player.m_21206_() : null);
        if (itemInHand == null) {
            return false;
        }
        if (player.m_6144_()) {
            if (currentBuildingChain != null) {
                currentBuildingChain = null;
                currentChainLevel = null;
            }
            return true;
        }
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return currentBuildingChain != null;
        }
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockPos hitPos = bhr.m_82425_();
        BlockState targetedState = level.m_8055_(hitPos);
        boolean validBlockTarget = PlacingCogwheelChain.isValidBlockTarget(targetedState);
        if (validBlockTarget && !BnbFeatureFlag.COGWHEEL_CHAIN_DRIVES.get()) {
            player.m_5661_(new ChainInteractionFailedException("config_forbids").getComponent(), true);
            return true;
        }
        if (!validBlockTarget) {
            return currentBuildingChain != null;
        }
        event.setSwingHand(true);
        if (currentBuildingChain == null || currentChainLevel == null || !currentChainLevel.equals((Object)level.m_46472_())) {
            currentBuildingChain = new PlacingCogwheelChain(hitPos, (Direction.Axis)targetedState.m_61143_((Property)CogWheelBlock.AXIS), PlacingCogwheelChain.isLargeBlockTarget(targetedState), PlacingCogwheelChain.hasSmallCogwheelOffset(targetedState));
            currentChainLevel = level.m_46472_();
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.bits_n_bobs.chain_drive_placing_hint"), true);
        } else {
            if (currentBuildingChain.getLastNode().pos().equals((Object)hitPos)) {
                currentBuildingChain.removeLastNode();
                if (currentBuildingChain.getNodes().isEmpty()) {
                    currentBuildingChain = null;
                    currentChainLevel = null;
                }
                return true;
            }
            try {
                boolean completed;
                boolean added = currentBuildingChain.tryAddNode(hitPos, targetedState);
                if (!added) {
                    return true;
                }
                try {
                    completed = currentBuildingChain.canBuildChainIfLooping();
                }
                catch (ChainInteractionFailedException exception) {
                    player.m_5661_(exception.getComponent(), true);
                    currentBuildingChain = null;
                    currentChainLevel = null;
                    return true;
                }
                if (completed) {
                    BnbPackets.getChannel().sendToServer((Object)new PlaceCogwheelChainPacket(currentBuildingChain, event.getHand().ordinal()));
                    currentBuildingChain = null;
                    currentChainLevel = null;
                }
            }
            catch (ChainInteractionFailedException exception) {
                player.m_5661_(exception.getComponent(), true);
            }
        }
        return true;
    }
}

