/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CogwheelChainTangents {
    public static Vec3 getTangentOnCog(PlacingCogwheelNode previousNode, int previousSide, PlacingCogwheelNode currentNode, int currentSide) {
        double previousRadius = previousNode.isLarge() ? 1.0 : 0.5;
        double currentRadius = currentNode.isLarge() ? 1.0 : 0.5;
        Vec3 incoming = currentNode.center().m_82546_(previousNode.center());
        if (previousNode.rotationAxis() != currentNode.rotationAxis()) {
            int incomingSign;
            Vec3 projectedIncoming = incoming.m_82546_(CogwheelChainTangents.getDirectionOfAxis(currentNode).m_82490_(incoming.m_82526_(CogwheelChainTangents.getDirectionOfAxis(currentNode)))).m_82546_(CogwheelChainTangents.getDirectionOfAxis(previousNode).m_82490_(incoming.m_82526_(CogwheelChainTangents.getDirectionOfAxis(previousNode)))).m_82541_();
            if (projectedIncoming.m_82556_() < 1.0E-7) {
                return null;
            }
            int n = incomingSign = projectedIncoming.m_82537_(CogwheelChainTangents.getDirectionOfAxis(previousNode)).m_82526_(CogwheelChainTangents.getDirectionOfAxis(currentNode)) > 0.0 ? 1 : -1;
            if (incomingSign != previousSide || incomingSign != currentSide) {
                return null;
            }
            return CogwheelChainTangents.getDirectionOfAxis(previousNode).m_82490_((double)previousNode.pos().m_121996_((Vec3i)currentNode.pos()).m_123304_(previousNode.rotationAxis()));
        }
        if (previousSide == currentSide) {
            return incoming.m_82541_().m_82537_(CogwheelChainTangents.getDirectionOfAxis(currentNode)).m_82490_(-currentRadius * (double)currentSide);
        }
        double factor = previousRadius / (previousRadius + currentRadius);
        Vec3 tangentOrigin = incoming.m_82490_(factor);
        double distance = tangentOrigin.m_82553_();
        double sineRatio = currentRadius / distance;
        double cosRatio = Math.sqrt(1.0 - sineRatio * sineRatio);
        double perpendicularHeight = cosRatio * currentRadius;
        double lengthAlongIncoming = sineRatio * currentRadius;
        return incoming.m_82541_().m_82537_(CogwheelChainTangents.getDirectionOfAxis(currentNode)).m_82490_(-perpendicularHeight * (double)currentSide).m_82549_(incoming.m_82541_().m_82490_(-lengthAlongIncoming));
    }

    @NotNull
    private static Vec3 getDirectionOfAxis(PlacingCogwheelNode currentNode) {
        return Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)currentNode.rotationAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_());
    }
}

