/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.block;

import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlockEntity;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.RenderedChainPathNode;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class CogwheelChainBlockEntityRenderer
extends KineticBlockEntityRenderer<CogwheelChainBlockEntity> {
    public static final ResourceLocation CHAIN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/block/chain.png");
    public static final int MIP_DISTANCE = 48;
    public static final int SEAM_DIST = 16;

    public CogwheelChainBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CogwheelChainBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        Function lighter = be.createGlobalLighter();
        CogwheelChain chain = be.getChain();
        if (be.isController() && chain != null) {
            float rotationsPerTick = be.getChainRotationFactor() * be.getSpeed() / 1200.0f;
            float time = be.m_58904_() != null ? AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_()) : AnimationTickHolder.getRenderTime();
            float offset = rotationsPerTick == 0.0f ? 0.0f : (float)(Math.PI * 2 * (double)rotationsPerTick * (double)time);
            double totalChainDistance = this.calculateTotalChainDistance(be);
            double chainTextureSquish = Math.ceil(totalChainDistance) / totalChainDistance;
            double accumulatedUV = 0.0;
            Vec3 origin = Vec3.m_82528_((Vec3i)be.m_58899_());
            int size = chain.getChainPathNodes().size();
            for (int i = 0; i < size; ++i) {
                RenderedChainPathNode node0 = chain.getChainPathNodes().get((size + i - 1) % size);
                RenderedChainPathNode node1 = chain.getChainPathNodes().get(i);
                RenderedChainPathNode node2 = chain.getChainPathNodes().get((i + 1) % size);
                RenderedChainPathNode node3 = chain.getChainPathNodes().get((i + 2) % size);
                double stretchOffset = (double)offset + accumulatedUV;
                double distance = node1.getPosition().m_82549_(origin).m_82554_(node2.getPosition().m_82549_(origin));
                accumulatedUV += distance;
                this.renderChain(be, ms, buffer, node3.getPosition().m_82549_(origin), node2.getPosition().m_82549_(origin), node1.getPosition().m_82549_(origin), node0.getPosition().m_82549_(origin), lighter, (float)stretchOffset, (float)chainTextureSquish);
            }
        }
    }

    private double calculateTotalChainDistance(CogwheelChainBlockEntity be) {
        double totalDistance = 0.0;
        Vec3 origin = Vec3.m_82528_((Vec3i)be.m_58899_());
        for (int i = 0; i < be.getChain().getChainPathNodes().size(); ++i) {
            RenderedChainPathNode nodeA = be.getChain().getChainPathNodes().get(i);
            RenderedChainPathNode nodeB = be.getChain().getChainPathNodes().get((i + 1) % be.getChain().getChainPathNodes().size());
            totalDistance += nodeA.getPosition().m_82549_(origin).m_82554_(nodeB.getPosition().m_82549_(origin));
        }
        return totalDistance;
    }

    private void renderChain(CogwheelChainBlockEntity be, PoseStack ms, MultiBufferSource buffer, Vec3 preFrom, Vec3 from, Vec3 to, Vec3 postTo, Function<Vector3f, Integer> lighter, float offset, float textureSquish) {
        boolean close;
        Vec3 diff = to.m_82546_(from);
        double yaw = 57.2957763671875 * Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_);
        double pitch = 57.2957763671875 * Mth.m_14136_((double)diff.f_82480_, (double)diff.m_82542_(1.0, 0.0, 1.0).m_82553_());
        BlockPos tilePos = be.m_58899_();
        Vec3 startOffset = from.m_82546_(Vec3.m_82512_((Vec3i)tilePos));
        ms.m_85836_();
        PoseTransformStack chain = TransformStack.of((PoseStack)ms);
        chain.center();
        chain.translate(startOffset);
        int light1 = lighter.apply(new Vector3f((float)from.f_82479_, (float)from.f_82480_, (float)from.f_82481_));
        int light2 = lighter.apply(new Vector3f((float)to.f_82479_, (float)to.f_82480_, (float)to.f_82481_));
        boolean far = Minecraft.m_91087_().f_91073_ == be.m_58904_() && !Minecraft.m_91087_().m_167982_().f_112249_.m_90583_().m_82509_((Position)from.m_165921_(to, 0.5), 48.0);
        boolean bl = close = Minecraft.m_91087_().f_91073_ == be.m_58904_() && Minecraft.m_91087_().m_167982_().f_112249_.m_90583_().m_82509_((Position)from.m_165921_(to, 0.5), 16.0);
        if (close) {
            CogwheelChainBlockEntityRenderer.renderChainSlowerButWithoutGaps(ms, buffer, offset, textureSquish, preFrom, from, to, postTo, light1, light2);
        } else {
            chain.rotateYDegrees((float)yaw);
            chain.rotateXDegrees(90.0f - (float)pitch);
            chain.rotateYDegrees(45.0f);
            float overextend = 0.05f;
            chain.translate(0.0f, 0.475f, 0.0f);
            chain.uncenter();
            CogwheelChainBlockEntityRenderer.renderChainFastButWithGaps(ms, buffer, offset - 0.025f, textureSquish, (float)from.m_82554_(to) + 0.05f, light1, light2, far);
        }
        ms.m_85849_();
    }

    private static void renderChainSlowerButWithoutGaps(PoseStack ms, MultiBufferSource buffer, float offset, float textureSquish, Vec3 preFrom, Vec3 from, Vec3 to, Vec3 postTo, int light1, int light2) {
        List<Vec3> endPoints = CogwheelChainBlockEntityRenderer.getEndPointsForChainJoint(from, to, postTo);
        List<Vec3> fromPoint = CogwheelChainBlockEntityRenderer.getEndPointsForChainJoint(preFrom, from, to);
        float length = (float)from.m_82554_(to);
        float minV = offset * textureSquish;
        float maxV = length * textureSquish + minV;
        float minU = 0.0f;
        float maxU = 0.1875f;
        ms.m_85836_();
        VertexConsumer vc = buffer.m_6299_(RenderTypes.chain((ResourceLocation)CHAIN_LOCATION));
        Matrix4f matrix4f = ms.m_85850_().m_252922_();
        Matrix3f normal = ms.m_85850_().m_252943_();
        for (int i = 0; i < 4; ++i) {
            float uO = i % 2 == 1 ? 0.0f : 0.1875f;
            CogwheelChainBlockEntityRenderer.addVertex(matrix4f, normal, vc, endPoints.get((i + 2) % 4).m_82546_(from), 0.0f + uO, minV, light1);
            CogwheelChainBlockEntityRenderer.addVertex(matrix4f, normal, vc, fromPoint.get((i + 2) % 4).m_82546_(from), 0.0f + uO, maxV, light1);
            CogwheelChainBlockEntityRenderer.addVertex(matrix4f, normal, vc, fromPoint.get(i).m_82546_(from), 0.1875f + uO, maxV, light1);
            CogwheelChainBlockEntityRenderer.addVertex(matrix4f, normal, vc, endPoints.get(i).m_82546_(from), 0.1875f + uO, minV, light1);
        }
        ms.m_85849_();
    }

    private static List<Vec3> getEndPointsForChainJoint(Vec3 before, Vec3 point, Vec3 after) {
        float radius = 0.09375f;
        Vec3 dirToBefore = point.m_82546_(before).m_82541_();
        Vec3 dirToAfter = after.m_82546_(point).m_82541_();
        Vec3 averagedDir = dirToBefore.m_82549_(dirToAfter).m_82541_();
        Quaternionf quat = new Quaternionf().rotationTo(0.0f, 1.0f, 0.0f, (float)averagedDir.f_82479_, (float)averagedDir.f_82480_, (float)averagedDir.f_82481_);
        Vector3d localAxis1Joml = quat.transform(1.0f, 0.0f, 0.0f, new Vector3d());
        Vec3 localAxis1 = new Vec3(localAxis1Joml.x, localAxis1Joml.y, localAxis1Joml.z).m_82541_();
        Vector3d localAxis2Joml = quat.transform(0.0f, 0.0f, 1.0f, new Vector3d());
        Vec3 localAxis2 = new Vec3(localAxis2Joml.x, localAxis2Joml.y, localAxis2Joml.z).m_82541_();
        return List.of(point.m_82549_(localAxis1.m_82549_(localAxis2).m_82541_().m_82490_(0.09375)), point.m_82549_(localAxis1.m_82546_(localAxis2).m_82541_().m_82490_(0.09375)), point.m_82549_(localAxis2.m_82490_(-1.0).m_82546_(localAxis1).m_82541_().m_82490_(0.09375)), point.m_82549_(localAxis2.m_82546_(localAxis1).m_82541_().m_82490_(0.09375)));
    }

    private static void renderChainFastButWithGaps(PoseStack ms, MultiBufferSource buffer, float offset, float textureSquish, float length, int light1, int light2, boolean far) {
        float radius = far ? 0.0625f : 0.09375f;
        float minV = far ? 0.0f : offset * textureSquish;
        float maxV = far ? 0.0625f : length * textureSquish + minV;
        float minU = far ? 0.1875f : 0.0f;
        float maxU = far ? 0.25f : 0.1875f;
        ms.m_85836_();
        ms.m_85837_(0.5, 0.0, 0.5);
        VertexConsumer vc = buffer.m_6299_(RenderTypes.chain((ResourceLocation)CHAIN_LOCATION));
        CogwheelChainBlockEntityRenderer.renderPart(ms, vc, length, 0.0f, radius, radius, 0.0f, -radius, 0.0f, 0.0f, -radius, minU, maxU, minV, maxV, light1, light2, far);
        ms.m_85849_();
    }

    private static void renderPart(PoseStack pPoseStack, VertexConsumer pConsumer, float pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2, boolean far) {
        Matrix3f posestack$pose = pPoseStack.m_85850_().m_252943_();
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        float uO = far ? 0.0f : 0.1875f;
        CogwheelChainBlockEntityRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        CogwheelChainBlockEntityRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        CogwheelChainBlockEntityRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        CogwheelChainBlockEntityRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2) {
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, Vec3 pPos, float pU, float pV, int light) {
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, (float)pPos.f_82480_, (float)pPos.f_82479_, (float)pPos.f_82481_, pU, pV, light);
    }

    private static void addVertex(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pY, float pX, float pZ, float pU, float pV, int light) {
        pConsumer.m_252986_(pPose, pX, pY, pZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(pU, pV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRenderOffScreen(CogwheelChainBlockEntity blockEntity) {
        return true;
    }
}

