/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.block;

import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlock;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import com.kipti.bnb.content.girder_strut.IBlockEntityRelighter;
import com.simibubi.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CogwheelChainBlockEntity
extends SimpleKineticBlockEntity
implements IBlockEntityRelighter,
SpecialBlockEntityItemRequirement {
    private boolean isController = false;
    @Nullable
    private CogwheelChain chain = null;
    @Nullable
    private Vec3i controllerOffset = null;
    private int chainsToRefund = 0;

    public CogwheelChainBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(5);
    }

    public void lazyTick() {
        BlockPos controllerPos;
        BlockEntity be;
        super.lazyTick();
        if (this.isController && this.chain != null) {
            if (!this.chain.checkIntegrity(this.f_58857_, this.f_58858_)) {
                this.destroyChain(true);
            }
        } else if (this.controllerOffset != null && this.f_58857_ != null && !((be = this.f_58857_.m_7702_(controllerPos = this.f_58858_.m_121955_(this.controllerOffset))) instanceof CogwheelChainBlockEntity)) {
            CogwheelChain.removeChainCogwheelFromLevelIfPresent(this.f_58857_, this.m_58899_());
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.isController = compound.m_128471_("IsController");
        this.controllerOffset = compound.m_128441_("ControllerOffsetX") ? new Vec3i(compound.m_128451_("ControllerOffsetX"), compound.m_128451_("ControllerOffsetY"), compound.m_128451_("ControllerOffsetZ")) : null;
        if (this.isController) {
            this.chainsToRefund = compound.m_128451_("ChainsToRefund");
            if (this.chain != null && compound.m_128441_("Chain")) {
                this.chain.read(compound.m_128469_("Chain"));
            } else {
                this.chain = new CogwheelChain(compound.m_128469_("Chain"));
            }
        } else {
            this.chain = null;
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.writeConnectionInfo(compound);
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        this.writeConnectionInfo(tag);
    }

    private void writeConnectionInfo(CompoundTag compound) {
        compound.m_128379_("IsController", this.isController);
        if (this.controllerOffset != null) {
            compound.m_128405_("ControllerOffsetX", this.controllerOffset.m_123341_());
            compound.m_128405_("ControllerOffsetY", this.controllerOffset.m_123342_());
            compound.m_128405_("ControllerOffsetZ", this.controllerOffset.m_123343_());
        }
        if (this.isController && this.chain != null) {
            CompoundTag chainTag = new CompoundTag();
            this.chain.write(chainTag);
            compound.m_128365_("Chain", (Tag)chainTag);
            compound.m_128405_("ChainsToRefund", this.chainsToRefund);
        }
    }

    public void destroy() {
        super.destroy();
        this.destroyChain(true);
    }

    public ItemStack destroyChain(boolean dropItemsInWorld) {
        BlockPos controllerPos;
        BlockEntity be;
        BlockPos controllerPos2;
        BlockEntity be2;
        int chainsToReturn = this.chainsToRefund;
        if (!this.isController && this.controllerOffset != null && this.f_58857_ != null && (be2 = this.f_58857_.m_7702_(controllerPos2 = this.f_58858_.m_121955_(this.controllerOffset))) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be2;
            chainsToReturn = controllerBE.chainsToRefund;
            controllerBE.chainsToRefund = 0;
        }
        ItemStack drops = Items.f_42026_.m_7968_().m_255036_(chainsToReturn);
        if (dropItemsInWorld) {
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)drops);
        }
        this.chainsToRefund = 0;
        if (this.isController && this.chain != null) {
            this.chain.destroy(this.f_58857_, this.f_58858_);
        }
        if (!this.isController && this.controllerOffset != null && this.f_58857_ != null && (be = this.f_58857_.m_7702_(controllerPos = this.f_58858_.m_121955_(this.controllerOffset))) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be;
            assert (controllerBE.chain != null);
            controllerBE.chain.destroy(this.f_58857_, controllerPos);
        }
        return drops;
    }

    public void setController(Vec3i offset) {
        this.isController = false;
        this.controllerOffset = offset;
    }

    public void setAsController(CogwheelChain cogwheelChain) {
        this.isController = true;
        this.chain = cogwheelChain;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(64.0);
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        BlockPos controllerPos;
        BlockEntity be;
        ArrayList<BlockPos> toPropagate = new ArrayList<BlockPos>(super.addPropagationLocations(block, state, neighbours));
        if (this.isController && this.chain != null) {
            this.addPropogationLocationsFromController(toPropagate, this.m_58899_());
        } else if (this.controllerOffset != null && this.f_58857_ != null && (be = this.f_58857_.m_7702_(controllerPos = this.f_58858_.m_121955_(this.controllerOffset))) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be;
            controllerBE.addPropogationLocationsFromController(toPropagate, this.m_58899_());
        }
        return toPropagate;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (connectedViaAxes && Math.abs(diff.m_123304_((Direction.Axis)this.m_58900_().m_61143_((Property)CogwheelChainBlock.AXIS))) == 1) {
            return 0.0f;
        }
        if (target instanceof CogwheelChainBlockEntity) {
            boolean isControlledBySame;
            CogwheelChainBlockEntity chainTarget = (CogwheelChainBlockEntity)target;
            boolean bl = isControlledBySame = this.isController && chainTarget.controllerOffset != null && chainTarget.controllerOffset.equals((Object)this.m_58899_().m_121996_((Vec3i)target.m_58899_())) || chainTarget.isController && this.controllerOffset != null && this.controllerOffset.equals((Object)target.m_58899_().m_121996_((Vec3i)this.m_58899_())) || chainTarget.controllerOffset != null && this.controllerOffset != null && this.controllerOffset.m_121955_((Vec3i)this.m_58899_()).equals((Object)chainTarget.controllerOffset.m_121955_((Vec3i)target.m_58899_()));
            if (isControlledBySame) {
                float currentSide = this.getChainRotationFactor();
                float otherSide = chainTarget.getChainRotationFactor();
                return currentSide / otherSide;
            }
        }
        return 0.0f;
    }

    public float getChainRotationFactor() {
        if (this.isController) {
            if (this.chain == null) {
                return 0.0f;
            }
            PathedCogwheelNode controllerNode = this.chain.getNodeFromControllerOffset(new Vec3i(0, 0, 0));
            if (controllerNode == null) {
                return 0.0f;
            }
            return controllerNode.sideFactor();
        }
        if (this.f_58857_ == null || this.controllerOffset == null) {
            return 0.0f;
        }
        BlockPos controllerPos = this.f_58858_.m_121955_(this.controllerOffset);
        BlockEntity be = this.f_58857_.m_7702_(controllerPos);
        if (be instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be;
            CogwheelChain controllerChain = controllerBE.chain;
            if (controllerChain == null) {
                return 0.0f;
            }
            PathedCogwheelNode nodeInChain = controllerChain.getNodeFromControllerOffset(this.controllerOffset);
            return nodeInChain == null ? 0.0f : nodeInChain.sideFactor();
        }
        return 0.0f;
    }

    private void addPropogationLocationsFromController(List<BlockPos> toPropagate, BlockPos exclude) {
        assert (this.chain != null);
        for (PathedCogwheelNode cogwheelNode : this.chain.getChainPathCogwheelNodes()) {
            BlockPos cogwheelPos = this.f_58858_.m_121955_((Vec3i)cogwheelNode.localPos());
            if (toPropagate.contains(cogwheelPos) || cogwheelPos.equals((Object)exclude)) continue;
            toPropagate.add(cogwheelPos);
        }
    }

    public boolean isController() {
        return this.isController;
    }

    public void setController(boolean controller) {
        this.isController = controller;
    }

    @Nullable
    public CogwheelChain getChain() {
        return this.chain;
    }

    public void setChain(@Nullable CogwheelChain chain) {
        this.chain = chain;
    }

    @Nullable
    public Vec3i getControllerOffset() {
        return this.controllerOffset;
    }

    public void setControllerOffset(@Nullable Vec3i controllerOffset) {
        this.controllerOffset = controllerOffset;
    }

    public void setChainsUsed(int chainsUsed) {
        this.chainsToRefund = chainsUsed;
    }

    public void clearStoredChains() {
        BlockPos controllerPos;
        BlockEntity be;
        if (this.isController) {
            this.chainsToRefund = 0;
        } else if (this.controllerOffset != null && this.f_58857_ != null && (be = this.f_58857_.m_7702_(controllerPos = this.f_58858_.m_121955_(this.controllerOffset))) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be;
            controllerBE.chainsToRefund = 0;
        }
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        return this.isController ? new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, Blocks.f_50184_.m_5456_().m_7968_().m_255036_(this.chain != null ? this.chain.getChainsRequired() : 0)) : ItemRequirement.NONE;
    }
}

