/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.chair;

import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class ChairBlock
extends SeatBlock
implements IWrenchable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LEFT_ARM = BooleanProperty.m_61465_((String)"left_arm");
    public static final BooleanProperty RIGHT_ARM = BooleanProperty.m_61465_((String)"right_arm");
    public static final BooleanProperty BACK_FLAT = BooleanProperty.m_61465_((String)"back_flat");
    public static final BooleanProperty FORCED_BACK_FLAT = BooleanProperty.m_61465_((String)"forced_back_flat");
    public static final BooleanProperty INVERTED_CORNER = BooleanProperty.m_61465_((String)"inverted_corner");
    public static final BooleanProperty CORNER = BooleanProperty.m_61465_((String)"corner");

    public ChairBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LEFT_ARM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BACK_FLAT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FORCED_BACK_FLAT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INVERTED_CORNER, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockState newState = (BlockState)state.m_61122_((Property)FORCED_BACK_FLAT);
        boolean isForcedFlat = (Boolean)newState.m_61143_((Property)FORCED_BACK_FLAT);
        context.m_43725_().m_46597_(context.m_8083_(), newState);
        context.m_43725_().m_5594_(null, context.m_8083_(), isForcedFlat ? SoundEvents.f_12628_ : SoundEvents.f_12629_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult p_225533_6_) {
        if (player.m_6144_() || player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)AllItems.WRENCH.get())) {
            return InteractionResult.PASS;
        }
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null && color != this.color) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties((BlockState)state, (BlockState)BnbBlocks.CHAIRS.get(color).getDefaultState());
            level.m_46597_(pos, newState);
            return InteractionResult.SUCCESS;
        }
        List seats = level.m_45976_(SeatEntity.class, new AABB(pos));
        if (!seats.isEmpty()) {
            SeatEntity seatEntity = (SeatEntity)seats.get(0);
            List passengers = seatEntity.m_20197_();
            if (!passengers.isEmpty() && passengers.get(0) instanceof Player) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                seatEntity.m_20153_();
                player.m_20329_((Entity)seatEntity);
            }
            return InteractionResult.SUCCESS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ChairBlock.sitDown((Level)level, (BlockPos)pos, (Entity)((Entity)ChairBlock.getLeashed((Level)level, (Player)player).or((Object)player)));
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, LEFT_ARM, RIGHT_ARM, CORNER, BACK_FLAT, FORCED_BACK_FLAT, INVERTED_CORNER});
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        return this.calculateShape((BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_()), (LevelAccessor)pContext.m_43725_(), pContext.m_8083_());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        BlockState blockState = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
        return this.calculateShape(blockState, pLevel, pCurrentPos);
    }

    @NotNull
    private BlockState calculateShape(BlockState blockState, LevelAccessor pLevel, BlockPos pCurrentPos) {
        boolean isCorner;
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        BlockState stateLeft = pLevel.m_8055_(pCurrentPos.m_121945_(facing.m_122427_()));
        boolean hasConnectableLeft = AllBlocks.SEATS.contains(stateLeft.m_60734_()) || stateLeft.m_60734_() instanceof ChairBlock && (stateLeft.m_61143_((Property)FACING) == facing || stateLeft.m_61143_((Property)FACING) == facing.m_122428_() || (Boolean)stateLeft.m_61143_((Property)INVERTED_CORNER) != false);
        BlockState stateRight = pLevel.m_8055_(pCurrentPos.m_121945_(facing.m_122428_()));
        boolean hasConnectableRight = AllBlocks.SEATS.contains(stateRight.m_60734_()) || stateRight.m_60734_() instanceof ChairBlock && (stateRight.m_61143_((Property)FACING) == facing || stateRight.m_61143_((Property)FACING) == facing.m_122427_() || (Boolean)stateRight.m_61143_((Property)INVERTED_CORNER) != false);
        BlockState stateFront = pLevel.m_8055_(pCurrentPos.m_121945_(facing));
        boolean hasConnectableFront = stateFront.m_60734_() instanceof ChairBlock && (stateFront.m_61143_((Property)FACING) == facing.m_122428_() || stateFront.m_61143_((Property)FACING) == facing.m_122427_());
        BlockState stateBack = pLevel.m_8055_(pCurrentPos.m_121945_(facing.m_122424_()));
        boolean isFlatBack = BnbBlocks.CHAIRS.contains(stateBack.m_60734_()) || stateBack.m_60838_((BlockGetter)pLevel, pCurrentPos.m_121945_(facing.m_122424_()));
        boolean isInvertedCorner = stateBack.m_60734_() instanceof ChairBlock && ((Direction)stateBack.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && (hasConnectableRight || hasConnectableLeft);
        boolean bl = isCorner = hasConnectableFront && hasConnectableLeft != hasConnectableRight;
        if (hasConnectableFront) {
            Direction cornerFacing = hasConnectableLeft ? facing.m_122428_() : facing.m_122427_();
            BlockPos cornerPos = pCurrentPos.m_121945_(cornerFacing);
            BlockState stateBackCorner = pLevel.m_8055_(cornerPos);
            isFlatBack = isFlatBack || isCorner && (BnbBlocks.CHAIRS.contains(stateBackCorner.m_60734_()) || stateBackCorner.m_60838_((BlockGetter)pLevel, cornerPos));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)LEFT_ARM, (Comparable)Boolean.valueOf(!hasConnectableLeft))).m_61124_((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(!hasConnectableRight))).m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(isCorner))).m_61124_((Property)BACK_FLAT, (Comparable)Boolean.valueOf(isFlatBack))).m_61124_((Property)INVERTED_CORNER, (Comparable)Boolean.valueOf(isInvertedCorner));
    }

    private static boolean getFlatObstructing(LevelAccessor pLevel, BlockState thisState, BlockPos pCurrentPos, Direction facing, BlockState blockState, BooleanProperty property) {
        BlockState sideState = pLevel.m_8055_(pCurrentPos.m_121945_(facing));
        return sideState.m_60734_() instanceof ChairBlock && sideState.m_61143_((Property)FACING) == facing;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rotation) {
        return (BlockState)super.m_6843_(state, rotation).m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }
}

