/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface ItemAttribute {
    public static CompoundTag saveStatic(ItemAttribute attribute) {
        CompoundTag nbt = new CompoundTag();
        ResourceLocation id = CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE.m_7981_((Object)attribute.getType());
        if (id == null) {
            throw new IllegalArgumentException("Cannot get " + String.valueOf(attribute.getType()) + " as it does not exist in AllRegistries.ITEM_ATTRIBUTE_TYPES");
        }
        nbt.m_128359_("attributeId", id.toString());
        attribute.save(nbt);
        return nbt;
    }

    @Nullable
    public static ItemAttribute loadStatic(CompoundTag nbt) {
        for (LegacyDeserializer deserializer : LegacyDeserializer.ALL) {
            if (!deserializer.canRead(nbt)) continue;
            return deserializer.readNBT(nbt.m_128469_(deserializer.getNBTKey()));
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("attributeId"));
        if (id == null) {
            return null;
        }
        ItemAttributeType type = (ItemAttributeType)CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE.m_7745_(id);
        if (type == null) {
            return null;
        }
        ItemAttribute attribute = type.createAttribute();
        attribute.load(nbt);
        return attribute;
    }

    public static List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
        for (ItemAttributeType type : CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE) {
            attributes.addAll(type.getAllAttributes(stack, level));
        }
        return attributes;
    }

    public boolean appliesTo(ItemStack var1, Level var2);

    public ItemAttributeType getType();

    public void save(CompoundTag var1);

    public void load(CompoundTag var1);

    @OnlyIn(value=Dist.CLIENT)
    default public MutableComponent format(boolean inverted) {
        return CreateLang.translateDirect("item_attributes." + this.getTranslationKey() + (inverted ? ".inverted" : ""), this.getTranslationParameters());
    }

    public String getTranslationKey();

    default public Object[] getTranslationParameters() {
        return new String[0];
    }

    @Deprecated
    public static interface LegacyDeserializer {
        public static final List<LegacyDeserializer> ALL = new ArrayList<LegacyDeserializer>();

        default public boolean canRead(CompoundTag nbt) {
            return nbt.m_128441_(this.getNBTKey());
        }

        public String getNBTKey();

        public ItemAttribute readNBT(CompoundTag var1);
    }
}

