/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid;

import com.github.mim1q.minecells.structure.MineCellsStructures;
import com.github.mim1q.minecells.structure.grid.MineCellsStructurePoolBasedGenerator;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3215;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3773;
import net.minecraft.class_3785;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;

public class GridPiece
extends class_3443 {
    private final class_5455 registryManager;
    private final class_3485 manager;
    private final class_2960 template;
    private final class_2470 rotation;
    private final class_2338 pos;
    private final int size;

    public GridPiece(class_3195.class_7149 context, class_2960 poolId, class_2338 pos, class_2470 rotation, int size) {
        super(MineCellsStructures.GRID_PIECE, 0, class_3341.method_34390((class_2382)pos, (class_2382)pos.method_10069(size, size, size)));
        this.manager = context.comp_565();
        class_3785 pool = (class_3785)context.comp_561().method_30530(class_7924.field_41249).method_10223(poolId);
        if (pool == null) {
            throw new RuntimeException("Pool not found: " + String.valueOf(poolId));
        }
        this.pos = pos;
        this.rotation = rotation;
        this.size = size;
        this.registryManager = context.comp_561();
        this.template = poolId;
    }

    public GridPiece(class_6625 context, class_2487 nbt) {
        super(MineCellsStructures.GRID_PIECE, nbt);
        this.manager = context.comp_135();
        this.pos = new class_2338(nbt.method_10550("PosX"), nbt.method_10550("PosY"), nbt.method_10550("PosZ"));
        this.rotation = class_2470.valueOf((String)nbt.method_10558("Rot"));
        this.size = nbt.method_10550("Size");
        this.registryManager = context.comp_134();
        this.template = new class_2960(nbt.method_10558("Template"));
    }

    protected void method_14943(class_6625 context, class_2487 nbt) {
        nbt.method_10569("PosX", this.pos.method_10263());
        nbt.method_10569("PosY", this.pos.method_10264());
        nbt.method_10569("PosZ", this.pos.method_10260());
        nbt.method_10582("Rot", this.rotation.name());
        nbt.method_10569("Size", this.size);
        nbt.method_10582("Template", this.template.toString());
    }

    public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
        class_2338 startingPos = this.getStartingPos();
        class_7138 config = world.method_8398() instanceof class_3215 ? ((class_3215)world.method_8398()).method_41248() : null;
        class_2378 poolRegistry = this.registryManager.method_30530(class_7924.field_41249);
        Optional optPoolEntry = poolRegistry.method_40264(class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)this.template));
        if (optPoolEntry.isEmpty()) {
            return;
        }
        class_6880 poolEntry = (class_6880)optPoolEntry.get();
        MineCellsStructurePoolBasedGenerator.generate(world, chunkGenerator, this.registryManager, this.manager, structureAccessor, config, random, (int)world.method_8412() + this.pos.hashCode(), (class_6880<class_3785>)poolEntry, 8, startingPos, this.rotation);
    }

    private class_2338 getStartingPos() {
        return switch (this.rotation) {
            case class_2470.field_11463 -> new class_2338(this.pos.method_10263() + this.size - 1, this.pos.method_10264(), this.pos.method_10260());
            case class_2470.field_11464 -> new class_2338(this.pos.method_10263() + this.size - 1, this.pos.method_10264(), this.pos.method_10260() + this.size - 1);
            case class_2470.field_11465 -> new class_2338(this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260() + this.size - 1);
            default -> this.pos;
        };
    }

    public class_3773 method_16653() {
        return MineCellsStructures.GRID_PIECE;
    }
}

