/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.network;

import com.github.mim1q.minecells.client.gui.ConjunctiviusClientBossBar;
import com.github.mim1q.minecells.network.PacketIdentifiers;
import com.github.mim1q.minecells.network.s2c.ObeliskActivationS2CPacket;
import com.github.mim1q.minecells.network.s2c.SendUnlockedCellCrafterRecipesS2CPacket;
import com.github.mim1q.minecells.network.s2c.ShockwaveClientEventS2CPacket;
import com.github.mim1q.minecells.network.s2c.SpawnRuneParticlesS2CPacket;
import com.github.mim1q.minecells.network.s2c.SyncMineCellsPlayerDataS2CPacket;
import com.github.mim1q.minecells.network.s2c.UpdateConjunctiviusBossBarS2CPacket;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_345;
import net.minecraft.class_5819;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.CRIT, ClientPacketHandler::handleCrit);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.EXPLOSION, ClientPacketHandler::handleExplosion);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.CONNECT, ClientPacketHandler::handleConnect);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.ELEVATOR_DESTROYED, ClientPacketHandler::handleElevatorDestroyed);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpawnRuneParticlesS2CPacket.ID, SpawnRuneParticlesS2CPacket::apply);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ObeliskActivationS2CPacket.ID, ObeliskActivationS2CPacket::apply);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncMineCellsPlayerDataS2CPacket.ID, SyncMineCellsPlayerDataS2CPacket::apply);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ShockwaveClientEventS2CPacket.ID, ShockwaveClientEventS2CPacket::apply);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SendUnlockedCellCrafterRecipesS2CPacket.ID, SendUnlockedCellCrafterRecipesS2CPacket::apply);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)UpdateConjunctiviusBossBarS2CPacket.ID, ClientPacketHandler::handleUpdateConjunctiviusBossBar);
    }

    private static void handleCrit(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        client.execute(() -> {
            if (client.field_1724 != null) {
                ParticleUtils.addAura(client.field_1687, pos, (class_2394)class_2398.field_11205, 8, 0.0, 1.0);
            }
        });
    }

    private static void handleExplosion(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        double radius = buf.readDouble();
        client.execute(() -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                client.field_1687.method_8466((class_2394)MineCellsParticles.EXPLOSION, true, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                client.field_1687.method_8466((class_2394)class_2398.field_11236, true, pos.field_1352 + 0.01, pos.field_1351 + 0.01, pos.field_1350 + 0.01, 0.0, 0.0, 0.0);
                class_5819 random = client.field_1687.field_9229;
                for (int i = 0; i < 20; ++i) {
                    double vx = (random.method_43058() - 0.5) * radius;
                    double vy = (random.method_43058() - 0.5) * radius;
                    double vz = (random.method_43058() - 0.5) * radius;
                    client.field_1687.method_8466((class_2394)class_2398.field_11205, true, pos.field_1352, pos.field_1351, pos.field_1350, vx, vy, vz);
                }
            }
        });
    }

    private static void handleConnect(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_243 pos0 = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        class_243 pos1 = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        client.execute(() -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                double amount = pos0.method_1022(pos1);
                class_243 vel = pos1.method_1020(pos0).method_1029();
                int i = 0;
                while ((double)i < amount) {
                    class_243 pos = MathUtils.lerp(pos0, pos1, (float)i / (float)amount);
                    ParticleUtils.addParticle(client.field_1687, (class_2394)class_2398.field_11208, pos, vel);
                    ++i;
                }
            }
        });
    }

    private static void handleElevatorDestroyed(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        client.execute(() -> {
            if (client.field_1687 != null) {
                class_2388 particle = new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564());
                class_238 box = new class_238(pos.method_1031(-1.0, 0.0, -1.0), pos.method_1031(1.0, 0.5, 1.0));
                ParticleUtils.addInBox(client.field_1687, (class_2394)particle, box, 25, new class_243(0.1, 0.1, 0.1));
            }
        });
    }

    private static void handleUpdateConjunctiviusBossBar(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID barUuid = buf.method_10790();
        short tentacleCount = buf.readShort();
        short maxTentacleCount = buf.readShort();
        client.execute(() -> {
            class_345 bar = (class_345)client.field_1705.method_1740().field_2060.get(barUuid);
            if (bar instanceof ConjunctiviusClientBossBar) {
                ConjunctiviusClientBossBar conjunctiviusBar = (ConjunctiviusClientBossBar)bar;
                conjunctiviusBar.setTentacleCount(tentacleCount, maxTentacleCount);
            }
        });
    }
}

