/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.mixin.entity.player;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.accessor.MineCellsBorderEntity;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.registry.MineCellsGameRules;
import com.github.mim1q.minecells.registry.MineCellsStatusEffects;
import com.github.mim1q.minecells.util.TeleportUtils;
import com.github.mim1q.minecells.world.state.MineCellsData;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657 {
    @Shadow
    public abstract boolean method_5679(class_1282 var1);

    @Shadow
    public abstract class_3218 method_51469();

    @Shadow
    public abstract class_5321<class_1937> method_26281();

    @Shadow
    @Nullable
    public abstract class_2338 method_26280();

    @Shadow
    public abstract float method_30631();

    @Shadow
    public abstract boolean method_7337();

    @Shadow
    public abstract boolean method_7325();

    @Shadow
    public abstract void method_43496(class_2561 var1);

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"attack"}, at={@At(value="RETURN")})
    public void attack(class_1297 target, CallbackInfo ci) {
        this.method_6016(MineCellsStatusEffects.ASSASSINS_STRENGTH);
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    public void damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_6012 < 60 && source.method_49708(class_8111.field_42340) && this.method_37908().method_8450().method_8355(MineCellsGameRules.SUFFOCATION_FIX) && !this.method_7337() && !this.method_7325() && MineCellsDimension.isMineCellsDimension(this.method_37908())) {
            MinecraftServer server = this.method_5682();
            if (server == null) {
                return;
            }
            class_2338 spawnPos = this.method_26280();
            if (spawnPos == null) {
                spawnPos = this.method_37908().method_43126();
            }
            class_3218 targetWorld = server.method_3847(this.method_26281());
            TeleportUtils.teleportToDimension((class_1297)this, targetWorld, class_243.method_24953((class_2382)spawnPos), this.method_30631());
            MineCells.LOGGER.info("Teleporting " + this.method_5477().getString() + " to their spawnpoint");
            this.method_43496((class_2561)class_2561.method_43470((String)"[Mine Cells] ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43471((String)"chat.minecells.suffocation_fix_message").method_27692(class_124.field_1068)));
        }
    }

    @Inject(method={"requestTeleport", "requestTeleportAndDismount"}, at={@At(value="HEAD")}, cancellable=true)
    private void minecells$cancelRequestTeleport(double destX, double destY, double destZ, CallbackInfo ci) {
        if (MineCellsDimension.isMineCellsDimension(this.method_37908()) && ((MineCellsBorderEntity)((Object)this)).getMineCellsBorder().method_11961(destX, destZ) < 2.0) {
            ci.cancel();
        }
    }

    @Inject(method={"onSpawn"}, at={@At(value="HEAD")})
    void minecells$injectOnSpawn(CallbackInfo ci) {
        MineCellsData.syncCurrentPlayerData((class_3222)this, this.method_51469());
        MineCells.DIMENSION_GRAPH.saveStuckPlayer((class_3222)this);
    }
}

