/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.mixin.entity;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.item.MineCellsItemTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class EntityFallResetMixin {
    @Shadow
    public float field_6017;
    @Shadow
    public int field_6012;
    @Unique
    private Double fallResetY = 0.0;
    @Unique
    private class_2338 lastSolidBlock;
    @Unique
    private class_5321<class_1937> lastWorld;

    @Shadow
    public abstract double method_23318();

    @Shadow
    public abstract class_1937 method_37908();

    @Shadow
    public abstract class_1923 method_31476();

    @Shadow
    public abstract class_2338 method_24515();

    @Shadow
    public abstract void method_20620(double var1, double var3, double var5);

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract void method_18799(class_243 var1);

    @Shadow
    public abstract class_1299<?> method_5864();

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract float method_5705(float var1);

    @Shadow
    public abstract double method_23321();

    @Shadow
    public abstract void method_31472();

    @Shadow
    public abstract boolean method_31747();

    @Shadow
    public abstract class_2561 method_5477();

    @Shadow
    public abstract void method_29239();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void minecells$injectInit(class_1299<?> type, class_1937 world, CallbackInfo ci) {
        this.fallResetY = MineCellsDimension.getFallResetHeight(world);
    }

    @Inject(method={"moveToWorld"}, at={@At(value="RETURN")})
    private void minecells$injectMoveToWorld(class_3218 destination, CallbackInfoReturnable<class_1297> cir) {
        class_1297 result = (class_1297)cir.getReturnValue();
        if (result == null) {
            return;
        }
        ((EntityFallResetMixin)result).fallResetY = MineCellsDimension.getFallResetHeight((class_1937)destination);
        this.lastSolidBlock = null;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void minecells$injectTick(CallbackInfo ci) {
        class_1657 player;
        class_1297 class_12972;
        class_5321 worldKey = this.method_37908().method_27983();
        if (!worldKey.equals(this.lastWorld)) {
            this.lastSolidBlock = null;
            this.lastWorld = worldKey;
            this.fallResetY = MineCellsDimension.getFallResetHeight(this.method_37908());
            return;
        }
        if (this.method_37908().field_9236 || MineCells.COMMON_CONFIG.disableFallProtection() || this.field_6012 < 10 || this.field_6012 % 2 == 0 || this.fallResetY == null || (class_12972 = (class_1297)this) instanceof class_1657 && ((player = (class_1657)class_12972).method_7337() || player.method_7325())) {
            return;
        }
        if (this.method_23318() < this.fallResetY) {
            if (this.method_5864() == class_1299.field_6052) {
                if (this.field_6012 % 20 != 0) {
                    return;
                }
                if (((class_1542)this).method_6983().method_31573(MineCellsItemTags.DISCARD_IN_HIGH_DIMENSIONS)) {
                    this.method_31472();
                    return;
                }
                class_1657 nearestPlayer = this.method_37908().method_18459(this.method_23317(), this.method_23318(), this.method_23321(), 180.0, false);
                if (nearestPlayer == null) {
                    return;
                }
                this.method_20620(nearestPlayer.method_23317(), nearestPlayer.method_23318(), nearestPlayer.method_23321());
                this.method_18799(class_243.field_1353);
                this.field_6017 = 0.0f;
                return;
            }
            if ((class_1297)this instanceof class_1588) {
                this.method_5643(this.method_37908().method_48963().method_48827(), 100.0f);
                return;
            }
            class_2338 tpPos = this.minecells$getResetToPos();
            this.method_29239();
            if (this.method_31747()) {
                MineCells.LOGGER.info("Fall protection mechanic triggered for Player {} at {} from {} in dimension {}", (Object)this.method_5477().getString(), (Object)tpPos.method_23854(), (Object)this.method_24515().method_23854(), (Object)this.method_37908().method_27983().method_29177());
                this.minecells$grantAdvancementCriterion();
            }
            this.method_20620((double)tpPos.method_10263() + 0.5, (double)tpPos.method_10264() + 0.5, (double)tpPos.method_10260() + 0.5);
            this.method_18799(class_243.field_1353);
            this.field_6017 = 0.0f;
            this.method_5643(this.method_37908().method_48963().method_48827(), 5.0f);
        } else if (this.method_23318() > this.fallResetY + 5.0 && this.method_37908().method_8320(this.method_24515().method_10074()).method_26212((class_1922)this.method_37908(), this.method_24515())) {
            this.lastSolidBlock = this.method_24515();
        }
    }

    @Unique
    private void minecells$grantAdvancementCriterion() {
        MinecraftServer server = this.method_37908().method_8503();
        if (server == null) {
            return;
        }
        class_161 advancement = server.method_3851().method_12896(MineCells.createId("unlock/fall_from_the_ramparts"));
        if (advancement == null) {
            return;
        }
        class_2985 tracker = ((class_3222)this).method_14236();
        tracker.method_12878(advancement, "teleported_up");
    }

    @Unique
    private class_2338 minecells$getResetToPos() {
        return class_2338.method_49638((class_2374)MineCellsDimension.of(this.method_37908()).getTeleportPosition(this.method_24515(), (class_3218)this.method_37908()));
    }
}

