/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.ai.goal.conjunctivius;

import com.github.mim1q.minecells.entity.ai.goal.conjunctivius.ConjunctiviusMoveAroundGoal;
import com.github.mim1q.minecells.entity.boss.ConjunctiviusEntity;
import com.github.mim1q.minecells.entity.nonliving.projectile.ConjunctiviusProjectileEntity;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6880;

public abstract class ConjunctiviusBarrageGoal
extends ConjunctiviusMoveAroundGoal {
    protected int ticks = 0;
    private class_1297 target;
    protected final BarrageSettings settings;

    public ConjunctiviusBarrageGoal(ConjunctiviusEntity entity, Consumer<BarrageSettings> settings) {
        super(entity);
        BarrageSettings settingsObj = new BarrageSettings();
        settings.accept(settingsObj);
        this.settings = settingsObj;
        this.speed = this.settings.speed;
    }

    @Override
    public boolean method_6264() {
        this.target = this.entity.method_5968();
        return super.method_6264() && this.entity.barrageCooldown <= 0 && this.target != null && this.entity.moving && this.entity.canAttack() && this.entity.method_6051().method_43057() < this.settings.chance;
    }

    @Override
    public boolean method_6266() {
        this.target = this.entity.method_5968();
        return this.target != null && this.ticks < this.settings.length + 60 && this.entity.canAttack();
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.entity.method_5841().method_12778(ConjunctiviusEntity.BARRAGE_ACTIVE, (Object)true);
        this.entity.method_5783(MineCellsSounds.CHARGE, 2.0f, 1.0f);
    }

    @Override
    public void method_6268() {
        if (this.entity.method_37908().field_9236) {
            return;
        }
        if (this.ticks > 60) {
            super.method_6268();
            if (this.ticks % 6 == 0) {
                class_3218 serverWorld = (class_3218)this.entity.method_37908();
                serverWorld.method_8503().method_3760().method_14605(null, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), 32.0, this.entity.method_37908().method_27983(), (class_2596)new class_2767(class_6880.method_40223((Object)MineCellsSounds.CONJUNCTIVIUS_SHOT), class_3419.field_15251, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), 0.25f, 1.0f, 0L));
            }
            if (this.ticks % this.settings.interval == 0) {
                this.shoot(this.entity, this.target);
            }
        }
        ++this.ticks;
    }

    protected abstract void shoot(ConjunctiviusEntity var1, class_1297 var2);

    @Override
    protected int getNextCooldown() {
        return this.entity.method_6051().method_39332(this.settings.minPause, this.settings.maxPause);
    }

    @Override
    public void method_6270() {
        this.ticks = 0;
        this.entity.barrageCooldown = this.settings.cooldown;
        this.entity.method_5841().method_12778(ConjunctiviusEntity.BARRAGE_ACTIVE, (Object)false);
        super.method_6270();
    }

    public static class BarrageSettings {
        public float chance = 0.5f;
        public float speed = 0.05f;
        public int interval = 8;
        public int length = 40;
        public int cooldown = 200;
        public int minPause = 40;
        public int maxPause = 80;
        public Supplier<Integer> count = () -> 1;
    }

    public static class Around
    extends ConjunctiviusBarrageGoal {
        public Around(ConjunctiviusEntity entity, Consumer<BarrageSettings> settings) {
            super(entity, settings);
        }

        @Override
        protected void shoot(ConjunctiviusEntity entity, class_1297 target) {
            if (target != null) {
                for (int i = 0; i < this.settings.count.get(); ++i) {
                    float yaw = MathUtils.radians(entity.method_36454());
                    float pitch = (float)(entity.method_6051().method_43058() - 0.8) * (float)Math.PI;
                    class_243 offset = new class_243((double)(class_3532.method_15374((float)(yaw += (float)(entity.method_6051().method_43058() - 0.5) * (float)Math.PI * 1.5f)) * class_3532.method_15362((float)pitch)), (double)class_3532.method_15374((float)pitch) + 2.5, (double)(class_3532.method_15362((float)yaw) * class_3532.method_15362((float)pitch)));
                    class_243 targetPos = entity.method_19538().method_1019(offset);
                    ConjunctiviusProjectileEntity.spawn(entity.method_37908(), entity.method_19538().method_1031(0.0, 2.5, 0.0), targetPos, this.entity);
                }
            }
        }
    }

    public static class Targeted
    extends ConjunctiviusBarrageGoal {
        public Targeted(ConjunctiviusEntity entity, Consumer<BarrageSettings> settings) {
            super(entity, settings);
        }

        @Override
        protected void shoot(ConjunctiviusEntity entity, class_1297 target) {
            if (target != null) {
                class_243 targetPos = target.method_19538().method_1031((entity.method_6051().method_43058() - 0.5) * 2.0, (entity.method_6051().method_43058() - 0.5) * 2.0 + 2.0, (entity.method_6051().method_43058() - 0.5) * 2.0);
                ConjunctiviusProjectileEntity.spawn(entity.method_37908(), entity.method_19538().method_1031(0.0, 2.5, 0.0), targetPos, this.entity);
            }
        }
    }
}

