/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedTeleportGoal;
import com.github.mim1q.minecells.entity.ai.goal.WalkTowardsTargetGoal;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_638;

public class RunnerEntity
extends MineCellsEntity {
    public static final class_2940<Boolean> TIMED_ATTACK_CHARGING = class_2945.method_12791(RunnerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> TIMED_ATTACK_RELEASING = class_2945.method_12791(RunnerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> TELEPORT_CHARGING = class_2945.method_12791(RunnerEntity.class, (class_2941)class_2943.field_13323);
    public AnimationProperty bendAngle = new AnimationProperty(0.0f);
    public AnimationProperty swingChargeProgress = new AnimationProperty(0.0f);
    public AnimationProperty swingReleaseProgress = new AnimationProperty(0.0f);
    private int attackCooldown = 0;
    private int teleportCooldown = 0;

    public RunnerEntity(class_1299<RunnerEntity> type, class_1937 world) {
        super(type, world);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TIMED_ATTACK_CHARGING, (Object)false);
        this.field_6011.method_12784(TIMED_ATTACK_RELEASING, (Object)false);
        this.field_6011.method_12784(TELEPORT_CHARGING, (Object)false);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new WalkTowardsTargetGoal((class_1314)this, 1.2f, false));
        this.field_6201.method_6277(0, (class_1352)new RunnerTimedAttackGoal(this, s -> {
            s.cooldownSetter = cooldown -> {
                this.attackCooldown = cooldown;
            };
            s.cooldownGetter = () -> this.attackCooldown;
            s.stateSetter = this::switchAttackState;
            s.chargeSound = MineCellsSounds.GRENADIER_CHARGE;
            s.releaseSound = MineCellsSounds.SWIPE;
            s.defaultCooldown = 35;
            s.actionTick = 12;
            s.length = 20;
        }));
        this.field_6201.method_6277(2, new TimedTeleportGoal<RunnerEntity>(this, s -> {
            s.cooldownSetter = cooldown -> {
                this.teleportCooldown = cooldown;
                this.attackCooldown = 40;
            };
            s.cooldownGetter = () -> this.teleportCooldown;
            s.stateSetter = this::switchTeleportState;
            s.defaultCooldown = 100;
            s.actionTick = 20;
            s.length = 40;
        }, (Predicate<RunnerEntity>)null));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (((Boolean)this.field_6011.method_12789(TELEPORT_CHARGING)).booleanValue() && this.method_37908().method_8608()) {
            for (int i = 0; i < 5; ++i) {
                ParticleUtils.addParticle((class_638)this.method_37908(), (class_2394)MineCellsParticles.CHARGE, this.method_19538().method_1031(0.0, (double)(this.method_17682() * 0.5f), 0.0), class_243.field_1353);
            }
        }
    }

    @Override
    protected void decrementCooldowns() {
        this.attackCooldown = Math.max(0, this.attackCooldown - 1);
        this.teleportCooldown = Math.max(0, this.teleportCooldown - 1);
    }

    public static class_5132.class_5133 createRunnerAttributes() {
        return RunnerEntity.method_26918().method_26868(class_5134.field_23716, 25.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23717, 14.0);
    }

    public void switchAttackState(TimedActionGoal.State state, boolean value) {
        switch (state) {
            case CHARGE: {
                this.field_6011.method_12778(TIMED_ATTACK_CHARGING, (Object)value);
                break;
            }
            case RELEASE: {
                this.field_6011.method_12778(TIMED_ATTACK_RELEASING, (Object)value);
            }
        }
    }

    public void switchTeleportState(TimedActionGoal.State state, boolean value) {
        if (state == TimedActionGoal.State.CHARGE) {
            this.field_6011.method_12778(TELEPORT_CHARGING, (Object)value);
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("attackCooldown", this.attackCooldown);
        nbt.method_10569("teleportCooldown", this.teleportCooldown);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.attackCooldown = nbt.method_10550("attackCooldown");
        this.teleportCooldown = nbt.method_10550("teleportCooldown");
    }

    public static class RunnerTimedAttackGoal
    extends TimedActionGoal<RunnerEntity> {
        protected class_1297 target;

        public RunnerTimedAttackGoal(RunnerEntity entity, Consumer<TimedActionGoal.TimedActionSettings> settingsConsumer) {
            super(entity, settingsConsumer, (E runner) -> runner.teleportCooldown < 80);
        }

        @Override
        public boolean method_6264() {
            this.target = ((RunnerEntity)this.entity).method_5968();
            return this.target != null && this.target.method_5805() && this.target.method_5732() && (double)((RunnerEntity)this.entity).method_5739(this.target) < 1.5 && super.method_6264();
        }

        @Override
        public void method_6268() {
            ((RunnerEntity)this.entity).method_5962().method_6239(this.target.method_23317(), this.target.method_23318(), this.target.method_23321(), 0.001);
            ((RunnerEntity)this.entity).method_5988().method_35111(this.target);
            super.method_6268();
        }

        @Override
        protected void runAction() {
            if (this.target.method_5805() && (double)((RunnerEntity)this.entity).method_5739(this.target) < 2.5) {
                ((RunnerEntity)this.entity).method_6121(this.target);
            }
        }
    }
}

