/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.data.spawner_runes;

import com.github.mim1q.minecells.MineCells;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_7923;

public record SpawnerRuneData(float cooldown, float spawnDistance, float playerDistance, List<Pool> pools) {
    public static final Codec<SpawnerRuneData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("cooldown", (Object)Float.valueOf(60.0f)).forGetter(SpawnerRuneData::cooldown), (App)Codec.FLOAT.optionalFieldOf("spawnDistance", (Object)Float.valueOf(0.0f)).forGetter(SpawnerRuneData::spawnDistance), (App)Codec.FLOAT.fieldOf("playerDistance").forGetter(SpawnerRuneData::playerDistance), (App)Pool.CODEC.listOf().fieldOf("pools").forGetter(SpawnerRuneData::pools)).apply((Applicative)instance, SpawnerRuneData::new));

    public List<EntitySpawnData> getSelectedEntities(class_5819 random) {
        ArrayList<EntitySpawnData> entities = new ArrayList<EntitySpawnData>();
        for (Pool pool : this.pools) {
            entities.addAll(pool.getSelectedEntities(random));
        }
        return entities;
    }

    private record Pool(class_6017 rolls, List<Entry> entries) {
        private static final Codec<Pool> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6017.field_33450.fieldOf("rolls").forGetter(Pool::rolls), (App)Entry.CODEC.listOf().fieldOf("entries").forGetter(Pool::entries)).apply((Applicative)instance, Pool::new));

        private List<EntitySpawnData> getSelectedEntities(class_5819 random) {
            int weightSum = this.entries.stream().map(e -> e.weight).reduce(Integer::sum).orElse(1);
            int count = this.rolls.method_35008(random);
            ArrayList<EntitySpawnData> entities = new ArrayList<EntitySpawnData>();
            for (int i = 0; i < count; ++i) {
                entities.add(this.chooseEntity(weightSum, random));
            }
            return entities;
        }

        private EntitySpawnData chooseEntity(int weightSum, class_5819 random) {
            int randomWeight = random.method_43048(weightSum);
            for (Entry entry : this.entries) {
                if ((randomWeight -= entry.weight) >= 0) continue;
                return new EntitySpawnData(entry.entityType, entry.attributeOverrides, entry.nbt);
            }
            return null;
        }
    }

    public record EntitySpawnData(class_1299<?> entityType, Map<class_1320, Double> attributeOverrides, class_2487 nbt) {
    }

    private static class Entry {
        private final int weight;
        private final class_1299<?> entityType;
        private final Map<String, Double> attributeMap;
        public final Map<class_1320, Double> attributeOverrides;
        public final class_2487 nbt = new class_2487();
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(e -> e.weight), (App)Codec.STRING.optionalFieldOf("entity", null).forGetter(e -> class_7923.field_41177.method_10221(e.entityType).toString()), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).optionalFieldOf("attributes", Map.of()).forGetter(e -> e.attributeMap), (App)class_2487.field_25128.optionalFieldOf("nbt", (Object)new class_2487()).forGetter(e -> e.nbt)).apply((Applicative)instance, Entry::new));

        private Entry(int weight, String entityType, Map<String, Double> attributeOverrides, class_2487 nbt) {
            this.weight = weight;
            this.entityType = entityType == null ? null : (class_1299)class_7923.field_41177.method_10223(class_2960.method_12829((String)entityType));
            this.attributeMap = attributeOverrides;
            this.attributeOverrides = attributeOverrides.entrySet().stream().map(entry -> {
                class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(class_2960.method_12829((String)((String)entry.getKey())));
                if (attribute == null) {
                    MineCells.LOGGER.warn("Unknown attribute in Spawner Rune data: " + (String)entry.getKey());
                    return null;
                }
                return Map.entry(attribute, (Double)entry.getValue());
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.nbt.method_10543(nbt);
        }
    }
}

