/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.block;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class FillerBlock
extends class_2248 {
    private final Predicate<class_2248> targetBlockPredicate;
    protected static final int MAX_DEPTH = 7;
    private final boolean usable;

    public FillerBlock(class_4970.class_2251 settings, Predicate<class_2248> targetBlockPredicate, boolean usable) {
        super(settings);
        this.targetBlockPredicate = targetBlockPredicate;
        this.usable = usable;
    }

    public FillerBlock(class_4970.class_2251 settings, class_2248 targetBlock, boolean usable) {
        super(settings);
        this.targetBlockPredicate = block -> block == targetBlock;
        this.usable = usable;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.usable) {
            return class_1269.field_5811;
        }
        class_2338 targetPos = this.findTarget(world, pos, 0);
        if (targetPos == null) {
            return class_1269.field_5814;
        }
        class_2680 targetState = world.method_8320(targetPos);
        return targetState.method_26204().method_9534(targetState, world, targetPos, player, hand, hit);
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }
        FillerBlock.destroyNeighbors(world, pos, this, this.targetBlockPredicate);
    }

    private class_2338 findTarget(class_1937 world, class_2338 pos, int depth) {
        class_2350[] dirs;
        if (depth >= 7) {
            return null;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : dirs = class_2350.values()) {
            mutable.method_25505((class_2382)pos, direction);
            class_2680 neighborState = world.method_8320((class_2338)mutable);
            if (this.targetBlockPredicate.test(neighborState.method_26204())) {
                return mutable;
            }
            class_2338 newTargetPos = this.findTarget(world, (class_2338)mutable, depth + 1);
            if (newTargetPos == null) continue;
            return newTargetPos;
        }
        return null;
    }

    public static void destroyNeighbors(class_1936 world, class_2338 pos, class_2248 filler, Predicate<class_2248> targetPredicate) {
        for (class_2338 neighbor : FillerBlock.getNeighbors(pos)) {
            class_2248 block = world.method_8320(neighbor).method_26204();
            if (block != filler && !targetPredicate.test(block)) continue;
            world.method_22352(neighbor, true);
            FillerBlock.destroyNeighbors(world, neighbor, filler, targetPredicate);
        }
    }

    private static ArrayList<class_2338> getNeighbors(class_2338 pos) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        result.add(pos.method_10084());
        result.add(pos.method_10074());
        result.add(pos.method_10095());
        result.add(pos.method_10072());
        result.add(pos.method_10078());
        result.add(pos.method_10067());
        return result;
    }
}

