/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.kayn.fallen_gems_affixes.event.PermanentEffectHandler;
import net.kayn.fallen_gems_affixes.util.EffectInstanceBucket;
import net.kayn.fallen_gems_affixes.util.EquipmentSlotWrapper;
import net.kayn.fallen_gems_affixes.util.EquipmentSlotWrappers;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ProtectedMobEffectMap<E extends LivingEntity>
extends HashMap<MobEffect, MobEffectInstance> {
    private final E owner;
    private final Map<MobEffect, EffectInstanceBucket> fallback = new HashMap<MobEffect, EffectInstanceBucket>();
    private final Map<EquipmentSlotWrapper, Set<MobEffect>> cachedEffectsBySlot = new HashMap<EquipmentSlotWrapper, Set<MobEffect>>();
    private final Set<MobEffect> currentPermanentEffects = new HashSet<MobEffect>();
    private EffectOperator operator = EffectOperator.EXTERNAL;
    private static final ThreadLocal<ItemStack> lastEffectsProvider = ThreadLocal.withInitial(() -> ItemStack.f_41583_);
    private static final ThreadLocal<EquipmentSlotWrapper> currentSlot = ThreadLocal.withInitial(() -> EquipmentSlotWrappers.NONE);

    public ProtectedMobEffectMap(E owner) {
        this.owner = owner;
    }

    @Override
    public MobEffectInstance put(MobEffect effect, MobEffectInstance effectInst) {
        if (this.owner instanceof Player && this.operator != EffectOperator.EXTERNAL) {
            this.addPermanentEffect(currentSlot.get(), effect, effectInst.m_19564_(), false);
        }
        return super.put(effect, effectInst);
    }

    @Override
    public MobEffectInstance remove(Object key) {
        if (!(this.owner instanceof Player)) {
            return (MobEffectInstance)super.remove(key);
        }
        if (this.operator == EffectOperator.EXTERNAL) {
            if (this.currentPermanentEffects.contains((MobEffect)key)) {
                return null;
            }
        } else {
            MobEffectInstance effectInst = (MobEffectInstance)super.remove(key);
            if (effectInst != null) {
                this.tryRemovePermanentEffect(currentSlot.get(), (MobEffect)key, effectInst.m_19564_(), false);
            }
            return effectInst;
        }
        return (MobEffectInstance)super.remove(key);
    }

    @Override
    public void clear() {
        if (!(this.owner instanceof Player)) {
            return;
        }
        if (this.operator == EffectOperator.EXTERNAL) {
            super.keySet().retainAll(PermanentEffectHandler.collectPermanentEffects(this.owner).keySet());
        } else {
            super.clear();
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (!(this.owner instanceof Player)) {
            return super.remove(key, value);
        }
        if (this.operator == EffectOperator.EXTERNAL) {
            if (this.currentPermanentEffects.contains((MobEffect)key)) {
                return false;
            }
        } else {
            if (value != null) {
                this.tryRemovePermanentEffect(currentSlot.get(), (MobEffect)key, ((MobEffectInstance)value).m_19564_(), false);
            }
            return true;
        }
        return super.remove(key, value);
    }

    @Override
    @NotNull
    public Collection<MobEffectInstance> values() {
        final Collection original = super.values();
        return new AbstractCollection<MobEffectInstance>(){

            @Override
            @NotNull
            public Iterator<MobEffectInstance> iterator() {
                final Iterator originalIterator = original.iterator();
                return new Iterator<MobEffectInstance>(){
                    MobEffectInstance current;

                    @Override
                    public boolean hasNext() {
                        return originalIterator.hasNext();
                    }

                    @Override
                    public MobEffectInstance next() {
                        this.current = (MobEffectInstance)originalIterator.next();
                        return this.current;
                    }

                    @Override
                    public void remove() {
                        if (ProtectedMobEffectMap.this.operator == EffectOperator.EXTERNAL) {
                            if (ProtectedMobEffectMap.this.currentPermanentEffects.contains(this.current.m_19544_())) {
                                return;
                            }
                        } else if (this.current != null) {
                            ProtectedMobEffectMap.this.tryRemovePermanentEffect(currentSlot.get(), this.current.m_19544_(), this.current.m_19564_(), false);
                        }
                        originalIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return original.size();
            }
        };
    }

    public boolean containsPermanent(MobEffect effect) {
        return this.currentPermanentEffects.contains(effect);
    }

    public Set<MobEffect> getEffectsFromCache(EquipmentSlotWrapper slot) {
        return this.cachedEffectsBySlot.get(slot);
    }

    public void setOperator(EffectOperator operator) {
        this.operator = operator;
    }

    public void setCurrentSlot(EquipmentSlotWrapper slot) {
        currentSlot.set(slot);
    }

    public Boolean isExternalRemover() {
        return this.operator == EffectOperator.EXTERNAL;
    }

    private void resetRemover() {
        this.operator = EffectOperator.EXTERNAL;
    }

    public void addPermanentEffect(EquipmentSlotWrapper slot, MobEffect effect, int amplifier, boolean isAltCondition) {
        if (effect == null) {
            return;
        }
        this.currentPermanentEffects.add(effect);
        this.tryUpdateCachedMobEffectsForSlot(slot, effect, PermanentEffectHandler.Operation.ADD, isAltCondition);
        EffectInstanceBucket potentialEffects = this.fallback.get(effect);
        if (potentialEffects == null) {
            potentialEffects = new EffectInstanceBucket(effect);
            this.fallback.put(effect, potentialEffects);
        }
        potentialEffects.add(amplifier);
    }

    private void updateCachedMobEffectsForSlot(EquipmentSlotWrapper slot, MobEffect effect, PermanentEffectHandler.Operation operation) {
        Set<MobEffect> effects = this.cachedEffectsBySlot.get(slot);
        if (effects == null) {
            effects = new HashSet<MobEffect>();
            this.cachedEffectsBySlot.put(slot, effects);
        }
        switch (operation) {
            case REMOVE: {
                effects.remove(effect);
                break;
            }
            case ADD: {
                effects.add(effect);
            }
        }
    }

    public void tryRemovePermanentEffect(EquipmentSlotWrapper slot, MobEffect effect, int amplifier, boolean altCondition) {
        if (effect == null) {
            return;
        }
        EffectInstanceBucket potentialEffects = this.fallback.get(effect);
        if (potentialEffects == null) {
            return;
        }
        potentialEffects.remove(amplifier);
        if (potentialEffects.size() == 0) {
            this.currentPermanentEffects.remove(effect);
            this.tryUpdateCachedMobEffectsForSlot(slot, effect, PermanentEffectHandler.Operation.REMOVE, altCondition);
        }
    }

    private void tryUpdateCachedMobEffectsForSlot(EquipmentSlotWrapper slot, MobEffect effect, PermanentEffectHandler.Operation operation, boolean isAltCondition) {
        if (this.owner.m_9236_().f_46443_ || isAltCondition) {
            this.updateCachedMobEffectsForSlot(slot, effect, operation);
        }
    }

    public MobEffectInstance getLastPotentialEffectInst(MobEffect effect) {
        return new MobEffectInstance(effect, -1, this.fallback.get(effect).getLast());
    }

    public void initOperation(EquipmentSlotWrapper slotWrapper, EffectOperator pOperator, ItemStack effectsProvide) {
        this.operator = pOperator;
        lastEffectsProvider.set(effectsProvide);
        currentSlot.set(slotWrapper);
    }

    public void initOperation(EquipmentSlotWrapper slotWrapper, EffectOperator pOperator) {
        this.operator = pOperator;
        currentSlot.set(slotWrapper);
    }

    public void initOperation(EquipmentSlotWrapper slotWrapper) {
        this.operator = EffectOperator.ON_EQUIP;
        currentSlot.set(slotWrapper);
    }

    public void finalizeOperation() {
        this.operator = EffectOperator.EXTERNAL;
        currentSlot.set(EquipmentSlotWrappers.NONE);
    }

    public ItemStack getLastEffectsProvider() {
        return lastEffectsProvider.get();
    }

    public void setLastEffectsProvider(ItemStack itemStack) {
        lastEffectsProvider.set(itemStack);
    }

    public static enum EffectOperator {
        ON_EQUIP,
        ON_HANDLER,
        ON_INIT,
        EXTERNAL;

    }
}

