/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

public class EquipmentSlotWrapper {
    private final EquipmentSlot slot;
    private final String identifier;
    private static final Map<EquipmentSlot, EquipmentSlotWrapper> vanillaEquipmentWrapper = new HashMap<EquipmentSlot, EquipmentSlotWrapper>();
    private static final Map<String, EquipmentSlotWrapper> allEquipmentWrappers = new HashMap<String, EquipmentSlotWrapper>();

    public EquipmentSlotWrapper(@Nullable EquipmentSlot slot, @NotNull String identifier) {
        this.slot = slot;
        if (slot != null) {
            vanillaEquipmentWrapper.put(slot, this);
        }
        this.identifier = identifier;
        allEquipmentWrappers.put(identifier, this);
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static Map<EquipmentSlot, EquipmentSlotWrapper> getVanillaWrapper() {
        return vanillaEquipmentWrapper;
    }

    public static Map<String, EquipmentSlotWrapper> getAll() {
        return allEquipmentWrappers;
    }

    public boolean equals(Object obj) {
        if (this == obj || this.slot != null && this.slot == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EquipmentSlotWrapper other = (EquipmentSlotWrapper)obj;
        return this.identifier.equals(other.identifier);
    }

    public String toString() {
        return this.identifier;
    }
}

