/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.init.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class GemLootModifier
extends LootModifier {
    public static final Supplier<Codec<GemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> GemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)GemEntry.CODEC.listOf().fieldOf("gems").forGetter(m -> m.gems)).apply((Applicative)inst, GemLootModifier::new)));
    private final List<GemEntry> gems;

    public GemLootModifier(LootItemCondition[] conditionsIn, List<GemEntry> gems) {
        super(conditionsIn);
        this.gems = gems;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource rand = context.m_230907_();
        float totalWeight = 0.0f;
        for (GemEntry entry : this.gems) {
            totalWeight += entry.drop_chance();
        }
        if (totalWeight <= 0.0f) {
            return generatedLoot;
        }
        float roll = rand.m_188501_() * totalWeight;
        float cumulative = 0.0f;
        for (GemEntry entry : this.gems) {
            if (!(roll <= (cumulative += entry.drop_chance()))) continue;
            ItemStack stack = this.createApotheosisGem(entry);
            if (stack.m_41619_()) break;
            generatedLoot.add((Object)stack);
            break;
        }
        return generatedLoot;
    }

    private ItemStack createApotheosisGem(GemEntry entry) {
        Item gemItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("apotheosis", "gem"));
        if (gemItem == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)gemItem);
        CompoundTag affixData = new CompoundTag();
        affixData.m_128359_("rarity", entry.rarity());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("affix_data", (Tag)affixData);
        nbt.m_128359_("gem", entry.gem());
        stack.m_41751_(nbt);
        return stack;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public record GemEntry(String gem, String rarity, float drop_chance) {
        public static final Codec<GemEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("gem").forGetter(GemEntry::gem), (App)Codec.STRING.fieldOf("rarity").forGetter(GemEntry::rarity), (App)Codec.FLOAT.fieldOf("drop_chance").forGetter(GemEntry::drop_chance)).apply((Applicative)inst, GemEntry::new));
    }
}

