/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.event;

import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoulboundEventHandler {
    private static final String TAG_SOULBOUND = "fallen_gems_affixes:soulbound_items";
    private static final String TAG_EQUIPPED_ITEMS = "fallen_gems_affixes:equipped_items";
    private static final ResourceLocation SOULBOUND_ID = new ResourceLocation("fallen_gems_affixes", "soulbound");
    private static final Map<UUID, List<ItemStack>> tempEquippedItems = new HashMap<UUID, List<ItemStack>>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ArrayList<ItemStack> equippedSoulbound = new ArrayList<ItemStack>();
        block0: for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot == EquipmentSlot.MAINHAND || (stack = player.m_6844_(slot)).m_41619_()) continue;
            Map affixes = AffixHelper.getAffixes((ItemStack)stack);
            for (DynamicHolder affixHolder : affixes.keySet()) {
                if (!SOULBOUND_ID.equals((Object)affixHolder.getId())) continue;
                equippedSoulbound.add(stack.m_41777_());
                continue block0;
            }
        }
        tempEquippedItems.put(player.m_20148_(), equippedSoulbound);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ArrayList<ItemStack> soulboundItems = new ArrayList<ItemStack>();
        List equippedItems = tempEquippedItems.getOrDefault(player.m_20148_(), new ArrayList());
        event.getDrops().removeIf(itemEntity -> {
            ItemStack stack = itemEntity.m_32055_();
            Map affixes = AffixHelper.getAffixes((ItemStack)stack);
            for (DynamicHolder affixHolder : affixes.keySet()) {
                if (!SOULBOUND_ID.equals((Object)affixHolder.getId())) continue;
                soulboundItems.add(stack.m_41777_());
                return true;
            }
            return false;
        });
        if (!soulboundItems.isEmpty()) {
            SoulboundEventHandler.storeSoulboundItems(player, soulboundItems, equippedItems);
        }
        tempEquippedItems.remove(player.m_20148_());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            CompoundTag originalData = event.getOriginal().getPersistentData();
            CompoundTag newData = event.getEntity().getPersistentData();
            if (originalData.m_128441_(TAG_SOULBOUND)) {
                newData.m_128365_(TAG_SOULBOUND, originalData.m_128423_(TAG_SOULBOUND));
            }
            if (originalData.m_128441_(TAG_EQUIPPED_ITEMS)) {
                newData.m_128365_(TAG_EQUIPPED_ITEMS, originalData.m_128423_(TAG_EQUIPPED_ITEMS));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        List<ItemStack> soulboundItems = SoulboundEventHandler.getSoulboundItems(player);
        List<ItemStack> equippedItems = SoulboundEventHandler.getEquippedItems(player);
        if (!soulboundItems.isEmpty()) {
            Inventory inv = player.m_150109_();
            if (inv.m_6643_() < 41 || !(player instanceof ServerPlayer)) {
                for (ItemStack stack01 : soulboundItems) {
                    if (inv.m_36054_(stack01)) continue;
                    player.m_36176_(stack01, false);
                }
                SoulboundEventHandler.clearSoulboundItems(player);
                return;
            }
            for (int t = soulboundItems.size() - 1; t >= 0; --t) {
                int slotIndex;
                EquipmentSlot equipmentSlot;
                ItemStack stack = soulboundItems.get(t);
                boolean wasEquipped = false;
                for (ItemStack equippedItem : equippedItems) {
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)equippedItem)) continue;
                    wasEquipped = true;
                    break;
                }
                boolean placed = false;
                if (wasEquipped && (equipmentSlot = LivingEntity.m_147233_((ItemStack)stack)) != EquipmentSlot.MAINHAND && (slotIndex = SoulboundEventHandler.getInventorySlotForEquipmentSlot(equipmentSlot)) != -1 && inv.m_8020_(slotIndex).m_41619_()) {
                    inv.m_6836_(slotIndex, stack);
                    placed = true;
                }
                if (placed || inv.m_36054_(stack)) continue;
                player.m_36176_(stack, false);
            }
            SoulboundEventHandler.clearSoulboundItems(player);
        }
    }

    private static int getInventorySlotForEquipmentSlot(EquipmentSlot equipmentSlot) {
        return switch (equipmentSlot) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.HEAD -> 39;
            case EquipmentSlot.CHEST -> 38;
            case EquipmentSlot.LEGS -> 37;
            case EquipmentSlot.FEET -> 36;
            case EquipmentSlot.OFFHAND -> 40;
            case EquipmentSlot.MAINHAND -> -1;
        };
    }

    private static void storeSoulboundItems(Player player, List<ItemStack> items, List<ItemStack> equippedItems) {
        CompoundTag compound = player.getPersistentData();
        ListTag itemListTag = new ListTag();
        for (ItemStack stack : items) {
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            itemListTag.add((Object)itemTag);
        }
        compound.m_128365_(TAG_SOULBOUND, (Tag)itemListTag);
        ListTag equippedListTag = new ListTag();
        for (ItemStack stack : equippedItems) {
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            equippedListTag.add((Object)itemTag);
        }
        compound.m_128365_(TAG_EQUIPPED_ITEMS, (Tag)equippedListTag);
    }

    private static List<ItemStack> getSoulboundItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        CompoundTag compound = player.getPersistentData();
        if (compound.m_128441_(TAG_SOULBOUND)) {
            ListTag listTag = compound.m_128437_(TAG_SOULBOUND, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag itemTag = listTag.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    private static List<ItemStack> getEquippedItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        CompoundTag compound = player.getPersistentData();
        if (compound.m_128441_(TAG_EQUIPPED_ITEMS)) {
            ListTag listTag = compound.m_128437_(TAG_EQUIPPED_ITEMS, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag itemTag = listTag.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    private static void clearSoulboundItems(Player player) {
        player.getPersistentData().m_128473_(TAG_SOULBOUND);
        player.getPersistentData().m_128473_(TAG_EQUIPPED_ITEMS);
    }
}

