/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;

public class PermanentEffectBonus
extends GemBonus {
    private final MobEffect effect;
    private final Map<LootRarity, Integer> values;
    public static final Codec<PermanentEffectBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(PermanentEffectBonus.gemClass(), (App)ResourceLocation.f_135803_.fieldOf("effect").xmap(arg_0 -> ((Registry)BuiltInRegistries.f_256974_).m_7745_(arg_0), arg_0 -> ((Registry)BuiltInRegistries.f_256974_).m_7981_(arg_0)).forGetter(b -> b.effect), (App)Codec.unboundedMap((Codec)LootRarity.CODEC, (Codec)Codec.INT).fieldOf("values").forGetter(b -> b.values)).apply((Applicative)inst, PermanentEffectBonus::new));

    public PermanentEffectBonus(GemClass gemClass, MobEffect effect, Map<LootRarity, Integer> values) {
        super(new ResourceLocation("fallen_gems_affixes", "permanent_effect"), gemClass);
        this.effect = effect;
        this.values = values;
    }

    public GemBonus validate() {
        Preconditions.checkNotNull((Object)this.effect, (Object)"Null mob effect");
        Preconditions.checkNotNull(this.values, (Object)"Null values map");
        return this;
    }

    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    public int getNumberOfUUIDs() {
        return 0;
    }

    public Component getSocketBonusTooltip(ItemStack itemStack, LootRarity lootRarity) {
        int amplifier = this.values.get(lootRarity);
        MutableComponent effectName = Component.m_237115_((String)this.effect.m_19481_());
        if (amplifier > 0) {
            effectName = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectName, Component.m_237115_((String)("potion.potency." + amplifier))});
        }
        effectName = effectName.m_130940_(this.effect.m_19483_().m_19497_());
        MutableComponent comp = Component.m_237110_((String)"bonus.fallen_gems_affixes:permanent_effect", (Object[])new Object[]{effectName}).m_130940_(ChatFormatting.YELLOW);
        MutableComponent infinity = Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"affix.fallen_gems_affixes.infinity")).m_130946_("]");
        return comp.m_130946_(" ").m_7220_((Component)infinity);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    public int getAmplifier(LootRarity rarity) {
        return this.values.get(rarity);
    }
}

