/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.PotionAffix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeEffectBonus
extends GemBonus {
    public static final Codec<AttributeEffectBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(AttributeEffectBonus.gemClass(), (App)ForgeRegistries.ATTRIBUTES.getCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)VALUES_CODEC.fieldOf("attribute_values").forGetter(a -> a.attributeValues), (App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)PotionAffix.Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("effect_values").forGetter(a -> a.effectValues), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply)).apply((Applicative)inst, AttributeEffectBonus::new));
    protected final Attribute attribute;
    protected final AttributeModifier.Operation operation;
    protected final Map<LootRarity, StepFunction> attributeValues;
    protected final MobEffect effect;
    protected final PotionAffix.Target target;
    protected final Map<LootRarity, EffectData> effectValues;
    protected final boolean stackOnReapply;

    public AttributeEffectBonus(GemClass gemClass, Attribute attribute, AttributeModifier.Operation operation, Map<LootRarity, StepFunction> attributeValues, MobEffect effect, PotionAffix.Target target, Map<LootRarity, EffectData> effectValues, boolean stackOnReapply) {
        super(new ResourceLocation("fallen_gems_affixes", "attribute_effect"), gemClass);
        this.attribute = attribute;
        this.operation = operation;
        this.attributeValues = attributeValues;
        this.effect = effect;
        this.target = target;
        this.effectValues = effectValues;
        this.stackOnReapply = stackOnReapply;
    }

    public void addModifiers(ItemStack gem, LootRarity rarity, BiConsumer<Attribute, AttributeModifier> map) {
        map.accept(this.attribute, this.readAttributeModifier(gem, rarity, (UUID)GemItem.getUUIDs((ItemStack)gem).get(0)));
    }

    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        MutableComponent attributeTooltip = IFormattableAttribute.toComponent((Attribute)this.attribute, (AttributeModifier)this.readAttributeModifier(gem, rarity, UUID.randomUUID()), (TooltipFlag)AttributesLib.getTooltipFlag());
        MobEffectInstance inst = this.effectValues.get(rarity).build(this.effect);
        MutableComponent effectTooltip = this.target.toComponent(new Object[]{AttributeEffectBonus.toComponent(inst)}).m_130940_(ChatFormatting.YELLOW);
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)});
            effectTooltip = effectTooltip.m_130946_(" ").m_7220_((Component)cd);
        }
        if (this.stackOnReapply) {
            effectTooltip = effectTooltip.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"affix.apotheosis.stacking"));
        }
        return Component.m_237119_().m_7220_((Component)attributeTooltip).m_7220_((Component)Component.m_237113_((String)" \u2022 ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)effectTooltip);
    }

    public int getNumberOfUUIDs() {
        return 1;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public boolean supports(LootRarity rarity) {
        return this.attributeValues.containsKey(rarity) && this.effectValues.containsKey(rarity);
    }

    public void doPostHurt(ItemStack gem, LootRarity rarity, LivingEntity user, Entity attacker) {
        if (this.target == PotionAffix.Target.HURT_SELF) {
            this.applyEffect(gem, user, rarity);
        } else if (this.target == PotionAffix.Target.HURT_ATTACKER && attacker instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)attacker;
            this.applyEffect(gem, tLiving, rarity);
        }
    }

    public void doPostAttack(ItemStack gem, LootRarity rarity, LivingEntity user, Entity target) {
        if (this.target == PotionAffix.Target.ATTACK_SELF) {
            this.applyEffect(gem, user, rarity);
        } else if (this.target == PotionAffix.Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffect(gem, tLiving, rarity);
        }
    }

    public void onBlockBreak(ItemStack gem, LootRarity rarity, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if (this.target == PotionAffix.Target.BREAK_SELF) {
            this.applyEffect(gem, (LivingEntity)player, rarity);
        }
    }

    public void onArrowImpact(ItemStack gemStack, LootRarity rarity, AbstractArrow arrow, HitResult res) {
        Entity entity;
        if (this.target == PotionAffix.Target.ARROW_SELF) {
            Entity entity2 = arrow.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                this.applyEffect(gemStack, owner, rarity);
            }
        } else if (this.target == PotionAffix.Target.ARROW_TARGET && res.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.applyEffect(gemStack, target, rarity);
        }
    }

    public float onShieldBlock(ItemStack gem, LootRarity rarity, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        if (this.target == PotionAffix.Target.BLOCK_SELF) {
            this.applyEffect(gem, entity, rarity);
        } else if (this.target == PotionAffix.Target.BLOCK_ATTACKER && (entity2 = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffect(gem, target, rarity);
        }
        return amount;
    }

    protected int getCooldown(LootRarity rarity) {
        EffectData data = this.effectValues.get(rarity);
        return data.cooldown;
    }

    private void applyEffect(ItemStack gemStack, LivingEntity target, LootRarity rarity) {
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0 && Affix.isOnCooldown((ResourceLocation)this.getCooldownId(gemStack), (int)cooldown, (LivingEntity)target)) {
            return;
        }
        EffectData data = this.effectValues.get(rarity);
        MobEffectInstance inst = target.m_21124_(this.effect);
        if (this.stackOnReapply && inst != null) {
            MobEffectInstance newInst = new MobEffectInstance(this.effect, Math.max(inst.m_19557_(), data.duration), inst.m_19564_() + 1 + data.amplifier);
            target.m_7292_(newInst);
        } else {
            target.m_7292_(data.build(this.effect));
        }
        Affix.startCooldown((ResourceLocation)this.getCooldownId(gemStack), (LivingEntity)target);
    }

    public AttributeModifier readAttributeModifier(ItemStack gem, LootRarity rarity, UUID id) {
        return new AttributeModifier(id, "apoth.gem_modifier", (double)this.attributeValues.get(rarity).get(0.0f), this.operation);
    }

    public static Component toComponent(MobEffectInstance inst) {
        MutableComponent mutablecomponent = Component.m_237115_((String)inst.m_19576_());
        MobEffect mobeffect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + inst.m_19564_()))});
        }
        if (inst.m_19557_() > 20) {
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)inst, (float)1.0f)});
        }
        return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public AttributeEffectBonus validate() {
        Preconditions.checkNotNull((Object)this.attribute, (Object)"Invalid AttributeEffectBonus with null attribute");
        Preconditions.checkNotNull((Object)this.operation, (Object)"Invalid AttributeEffectBonus with null operation");
        Preconditions.checkNotNull(this.attributeValues, (Object)"Invalid AttributeEffectBonus with null attribute values");
        Preconditions.checkNotNull((Object)this.effect, (Object)"Null mob effect");
        Preconditions.checkNotNull((Object)this.target, (Object)"Null target");
        Preconditions.checkNotNull(this.effectValues, (Object)"Null effect values map");
        return this;
    }

    public record EffectData(int duration, int amplifier, int cooldown) {
        private static final Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("duration").forGetter(EffectData::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(MobEffect effect) {
            return new MobEffectInstance(effect, this.duration, this.amplifier);
        }
    }
}

