/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.adventure.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SpellEffectAffix
extends Affix {
    public static final Codec<SpellEffectAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(a -> a.cooldown), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply), (App)Codec.intRange((int)1, (int)255).optionalFieldOf("stacking_limit", (Object)255).forGetter(a -> a.stackingLimit)).apply((Applicative)inst, SpellEffectAffix::new));
    protected final int cooldown;
    protected final MobEffect effect;
    public final Target target;
    protected final Map<LootRarity, EffectData> values;
    protected final Set<LootCategory> types;
    protected final int stackingLimit;
    protected final boolean stackOnReapply;

    public SpellEffectAffix(MobEffect effect, Target target, Map<LootRarity, EffectData> values, int cooldown, Set<LootCategory> types, boolean stackOnReapply, int stackingLimit) {
        super(AffixType.ABILITY);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.cooldown = cooldown;
        this.types = types;
        this.stackOnReapply = stackOnReapply;
        this.stackingLimit = stackingLimit;
    }

    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        MobEffectInstance inst = this.values.get(rarity).build(this.effect, level);
        MutableComponent comp = this.target.toComponent(SpellEffectAffix.toComponent(inst), SpellEffectAffix.toComponent(inst));
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        int cooldown;
        MutableComponent maxComp;
        MutableComponent minComp;
        MobEffectInstance inst = this.values.get(rarity).build(this.effect, level);
        MutableComponent comp = this.target.toComponent(SpellEffectAffix.toComponent(inst));
        MobEffectInstance min = this.values.get(rarity).build(this.effect, 0.0f);
        MobEffectInstance max = this.values.get(rarity).build(this.effect, 1.0f);
        if (min.m_19564_() != max.m_19564_()) {
            minComp = min.m_19564_() == 0 ? Component.m_237113_((String)"I") : Component.m_237115_((String)("potion.potency." + min.m_19564_()));
            maxComp = Component.m_237115_((String)("potion.potency." + max.m_19564_()));
            comp.m_7220_((Component)SpellEffectAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if (!this.effect.m_8093_() && min.m_19557_() != max.m_19557_()) {
            minComp = MobEffectUtil.m_267641_((MobEffectInstance)min, (float)1.0f);
            maxComp = MobEffectUtil.m_267641_((MobEffectInstance)max, (float)1.0f);
            comp.m_7220_((Component)SpellEffectAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if ((cooldown = this.getCooldown(rarity)) != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    public boolean canApplyTo(ItemStack itemStack, LootCategory lootCategory, LootRarity lootRarity) {
        return (this.types.isEmpty() || this.types.contains(lootCategory)) && this.values.containsKey(lootRarity);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public void applyEffect(LivingEntity target, LootRarity rarity, float level) {
        if (target.m_9236_().m_5776_()) {
            return;
        }
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0 && SpellEffectAffix.isOnCooldown((ResourceLocation)this.getId(), (int)cooldown, (LivingEntity)target)) {
            return;
        }
        EffectData data = this.values.get(rarity);
        MobEffectInstance inst = target.m_21124_(this.effect);
        if (this.stackOnReapply && inst != null) {
            if (inst != null) {
                int amplifier = Math.min(this.stackingLimit, (int)((float)(inst.m_19564_() + 1) + data.amplifier.get(level)));
                MobEffectInstance newInst = new MobEffectInstance(this.effect, (int)Math.max((float)inst.m_19557_(), data.duration.get(level)), amplifier);
                target.m_7292_(newInst);
            }
        } else {
            target.m_7292_(data.build(this.effect, level));
        }
        SpellEffectAffix.startCooldown((ResourceLocation)this.getId(), (LivingEntity)target);
    }

    protected int getCooldown(LootRarity rarity) {
        EffectData data = this.values.get(rarity);
        if (data.cooldown != -1) {
            return data.cooldown;
        }
        return this.cooldown;
    }

    public static Component toComponent(MobEffectInstance inst) {
        MutableComponent mutablecomponent = Component.m_237115_((String)inst.m_19576_());
        MobEffect mobeffect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + inst.m_19564_()))});
        }
        if (inst.m_19557_() > 20) {
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)inst, (float)1.0f)});
        }
        return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public static enum Target {
        SPELL_DAMAGE_SELF("spell_damage_self"),
        SPELL_DAMAGE_TARGET("spell_damage_target"),
        SPELL_HEAL_SELF("spell_heal_self"),
        SPELL_HEAL_TARGET("spell_heal_target");

        public static final Codec<Target> CODEC;
        private final String id;

        private Target(String id) {
            this.id = id;
        }

        public MutableComponent toComponent(Object ... args) {
            return Component.m_237110_((String)("affix.fallen_gems_affixes.target." + this.id), (Object[])args);
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(Target.class);
        }
    }

    public record EffectData(StepFunction duration, StepFunction amplifier, int cooldown) {
        private static final Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("duration").forGetter(EffectData::duration), (App)StepFunction.CODEC.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)-1).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(MobEffect effect, float level) {
            return new MobEffectInstance(effect, this.duration.getInt(level), this.amplifier.getInt(level));
        }
    }
}

