/*
 * Decompiled with CFR 0.152.
 */
package ru.hollowhorizon.additions.questing.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestButton;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.hollowhorizon.additions.questing.client.Animator;
import ru.hollowhorizon.additions.questing.client.QuestButtonAnimator;
import ru.hollowhorizon.additions.questing.client.QuestPanelAnimator;
import ru.hollowhorizon.additions.questing.config.QuestAnimationsConfig;
import ru.hollowhorizon.additions.questing.mixins.QuestScreenAccessor;

@Mixin(value={QuestButton.class}, remap=false)
public abstract class QuestButtonMixin
extends Button
implements QuestButtonAnimator {
    @Shadow
    @Final
    protected QuestScreen questScreen;
    @Shadow
    @Final
    Quest quest;
    @Unique
    private final Animator cqa$animator = new Animator(0.0f, 0.2f, i -> Float.valueOf(1.0f - (1.0f - i.floatValue()) * (1.0f - i.floatValue()) * (1.0f - i.floatValue())));

    @Override
    public Animator cqa$getAnimator() {
        return this.cqa$animator;
    }

    public QuestButtonMixin(Panel panel, Component t, Icon i2) {
        super(panel, t, i2);
    }

    @Shadow
    protected abstract String getShape();

    @Shadow
    public abstract Movable moveAndDeleteFocus();

    @Inject(method={"draw"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDraw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h, CallbackInfo ci) {
        int s;
        if (!((Boolean)QuestAnimationsConfig.QUEST_HOVER.get()).booleanValue()) {
            return;
        }
        if (this.isMouseOver()) {
            this.cqa$animator.set(1.0f);
        } else {
            this.cqa$animator.set(0.0f);
        }
        this.cqa$animator.update();
        float factor = this.cqa$animator.get();
        Color4I outlineColor = (Color4I)ThemeProperties.QUEST_NOT_STARTED_COLOR.get((QuestObjectBase)this.quest);
        Color4I questIcon = Color4I.empty();
        Color4I hiddenIcon = Color4I.empty();
        Color4I lockIcon = Color4I.empty();
        ClientQuestFile file = ((QuestScreenAccessor)this.questScreen).getFile();
        List<Movable> selectedObjects = ((QuestScreenAccessor)this.questScreen).getSelectedObjects();
        TeamData teamData = file.selfTeamData;
        boolean isCompleted = teamData.isCompleted((QuestObject)this.quest);
        boolean isStarted = isCompleted || teamData.isStarted((QuestObject)this.quest);
        boolean canStart = teamData.areDependenciesComplete(this.quest) && !teamData.isExcludedByOtherQuestline((QuestObject)this.quest);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (canStart) {
            if (isCompleted) {
                questIcon = teamData.hasUnclaimedRewards(player.m_20148_(), (QuestObject)this.quest) ? (Icon)ThemeProperties.ALERT_ICON.get((QuestObjectBase)this.quest) : (teamData.isQuestPinned((Player)player, this.quest.id) ? (Icon)ThemeProperties.PIN_ICON_ON.get() : (Icon)ThemeProperties.CHECK_ICON.get((QuestObjectBase)this.quest));
                outlineColor = (Color4I)ThemeProperties.QUEST_COMPLETED_COLOR.get((QuestObjectBase)this.quest);
            } else if (isStarted) {
                if (teamData.areDependenciesComplete(this.quest)) {
                    outlineColor = (Color4I)ThemeProperties.QUEST_STARTED_COLOR.get((QuestObjectBase)this.quest);
                }
                if (this.quest.getProgressionMode() == ProgressionMode.FLEXIBLE && this.quest.allTasksCompleted(teamData)) {
                    questIcon = new ThemeProperties.CheckIcon(Color4I.rgb((int)0x606060), Color4I.rgb((int)0x808080));
                }
            }
        } else {
            outlineColor = (Color4I)ThemeProperties.QUEST_LOCKED_COLOR.get((QuestObjectBase)this.quest);
        }
        if (questIcon == Color4I.empty() && teamData.isQuestPinned((Player)player, this.quest.id)) {
            questIcon = (Icon)ThemeProperties.PIN_ICON_ON.get();
        }
        if (file.canEdit() && !this.quest.isVisible(teamData)) {
            hiddenIcon = (Icon)ThemeProperties.HIDDEN_ICON.get();
        }
        PoseStack poseStack = graphics.m_280168_();
        QuestShape shape = QuestShape.get((String)this.getShape());
        float scale = 1.0f + 0.1f * factor;
        float dx = ((float)w * scale - (float)w) / 2.0f;
        float dy = ((float)h * scale - (float)h) / 2.0f;
        if (shape.shouldDraw()) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)x - dx, (float)y - dy, 0.0f);
            poseStack.m_85841_(scale, scale, scale);
            shape.getShape().withColor(Color4I.DARK_GRAY).draw(graphics, 0, 0, w, h);
            shape.getBackground().withColor(Color4I.WHITE.withAlpha(150)).draw(graphics, 0, 0, w, h);
            shape.getOutline().withColor(outlineColor).draw(graphics, 0, 0, w, h);
            poseStack.m_85849_();
        }
        if (!this.icon.isEmpty()) {
            int s2 = (int)((float)w * 0.6666667f * (float)this.quest.getIconScale());
            poseStack.m_85836_();
            poseStack.m_85837_((double)x + (double)(w - s2) / 2.0, (double)y + (double)(h - s2) / 2.0, 0.0);
            poseStack.m_252880_(-dx, -dy, 0.0f);
            poseStack.m_85841_(scale, scale, scale);
            this.icon.draw(graphics, 0, 0, s2, s2);
            poseStack.m_85849_();
        }
        GuiHelper.setupDrawing();
        if (this.questScreen.getViewedQuest() == this.quest || selectedObjects.contains(this.moveAndDeleteFocus())) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)x - dx, (float)y - dy, 1.0f);
            poseStack.m_85841_(scale, scale, scale);
            Color4I col = Color4I.WHITE.withAlpha((int)(190.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
            shape.getOutline().withColor(col).draw(graphics, 0, 0, w, h);
            shape.getBackground().withColor(col).draw(graphics, 0, 0, w, h);
            poseStack.m_85849_();
        }
        if (!canStart || !teamData.areDependenciesComplete(this.quest)) {
            if (shape.shouldDraw()) {
                shape.getShape().withColor(Color4I.BLACK.withAlpha(100)).draw(graphics, x, y, w, h);
            }
            if (this.quest.getQuestFile().showLockIcons() && ((Boolean)FTBQuestsClientConfig.SHOW_LOCK_ICON.get()).booleanValue()) {
                lockIcon = (Icon)ThemeProperties.LOCK_ICON.get();
            }
        }
        if (this.isMouseOver()) {
            shape.getShape().withColor(Color4I.WHITE.withAlpha((int)((float)((Integer)QuestAnimationsConfig.QUEST_HOVER_GLOW_ALPHA.get()).intValue() * factor))).draw(graphics, x, y, w, h);
        }
        float offset = 0.0f;
        if (!questIcon.isEmpty()) {
            s = (int)((float)w / 8.0f * 3.0f);
            poseStack.m_85836_();
            poseStack.m_252880_((float)(x + w - s) - dx, (float)y - dy, offset);
            poseStack.m_85841_(scale, scale, scale);
            questIcon.draw(graphics, 0, 0, s, s);
            poseStack.m_85849_();
        }
        if (!hiddenIcon.isEmpty()) {
            s = (int)((float)w / 8.0f * 3.0f);
            poseStack.m_85836_();
            poseStack.m_252880_((float)x - dx, (float)y - dy, offset);
            poseStack.m_85841_(scale, scale, scale);
            hiddenIcon.draw(graphics, 0, 0, s, s);
            poseStack.m_85849_();
        }
        if (!lockIcon.isEmpty() && !this.quest.shouldHideLockIcon()) {
            s = (int)((float)w / 8.0f * 3.0f);
            poseStack.m_85836_();
            poseStack.m_252880_((float)(x + w - s) - dx, (float)(y + h - 1 - s) - dy, offset);
            poseStack.m_85841_(scale, scale, scale);
            lockIcon.draw(graphics, 0, 0, s, s);
            poseStack.m_85849_();
        }
        ci.cancel();
    }

    @Inject(method={"onClicked"}, at={@At(value="INVOKE", target="Ldev/ftb/mods/ftbquests/client/gui/quests/QuestScreen;open(Ldev/ftb/mods/ftbquests/quest/QuestObject;Z)V", shift=At.Shift.AFTER)})
    private void cqa$onClicked(MouseButton button, CallbackInfo ci) {
        ((QuestPanelAnimator)this.questScreen.viewQuestPanel).cqa$triggerAnimation();
    }
}

