/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.common.space_objects.OrbitingObject;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Planet;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;
import net.povstalec.stellarview.compatibility.enhancedcelestials.EnhancedCelestialsCompatibility;
import net.povstalec.stellarview.compatibility.lunar.LunarCompatibility;

public class Moon
extends Planet {
    @Nullable
    private Compatibility compatibility;
    public static final Codec<Moon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(object -> Either.left((Object)object.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)OrbitingObject.OrbitInfo.CODEC.optionalFieldOf("orbit_info").forGetter(moon -> Optional.ofNullable(moon.orbitInfo())), (App)TextureLayer.CODEC.listOf().fieldOf("texture_layers").forGetter(TexturedObject::getTextureLayers), (App)TexturedObject.FadeOutHandler.CODEC.optionalFieldOf("fade_out_handler", (Object)TexturedObject.FadeOutHandler.DEFAULT_PLANET_HANDLER).forGetter(TexturedObject::getFadeOutHandler), (App)Compatibility.CODEC.optionalFieldOf("compatibility").forGetter(Moon::getCompatibility)).apply((Applicative)instance, Moon::new));

    public Moon() {
    }

    public Moon(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, Optional<OrbitingObject.OrbitInfo> orbitInfo, List<TextureLayer> textureLayers, TexturedObject.FadeOutHandler fadeOutHandler, Optional<Compatibility> compatibility) {
        super(parent, coords, axisRotation, orbitInfo, textureLayers, fadeOutHandler);
        if (compatibility.isPresent()) {
            this.compatibility = compatibility.get();
        }
    }

    public Optional<Compatibility> getCompatibility() {
        return Optional.ofNullable(this.compatibility);
    }

    public float sizeMultiplier(ClientLevel level) {
        if (this.getCompatibility().isPresent()) {
            if (StellarView.isEnhancedCelestialsLoaded() && level.m_46472_().equals(this.getCompatibility().get().enhancedCelestialsMoonDimension)) {
                return EnhancedCelestialsCompatibility.getMoonSize(level, 20.0f) / 20.0f;
            }
            if (StellarView.isLunarLoaded() && level.m_46472_().equals(this.getCompatibility().get().lunarMoonDimension)) {
                return LunarCompatibility.getMoonSize(20.0f) / 20.0f;
            }
        }
        return 1.0f;
    }

    public Color.FloatRGBA moonRGBA(ClientLevel level, float partialTicks) {
        if (this.getCompatibility().isPresent()) {
            if (StellarView.isEnhancedCelestialsLoaded() && level.m_46472_().equals(this.getCompatibility().get().enhancedCelestialsMoonDimension)) {
                return EnhancedCelestialsCompatibility.getMoonColor(level, partialTicks);
            }
            if (StellarView.isLunarLoaded() && level.m_46472_().equals(this.getCompatibility().get().lunarMoonDimension)) {
                return LunarCompatibility.getMoonColor();
            }
        }
        return new Color.FloatRGBA(1.0f, 1.0f, 1.0f);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
    }

    public static class Compatibility {
        private ResourceKey<Level> enhancedCelestialsMoonDimension;
        private ResourceKey<Level> lunarMoonDimension;
        public static final Codec<Compatibility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Level.f_46427_.fieldOf("enhanced_celestials_moon_dimension").forGetter(Compatibility::getEnhancedCelestialsMoonDimension), (App)Level.f_46427_.fieldOf("lunar_moon_dimension").forGetter(Compatibility::getLunarMoonDimension)).apply((Applicative)instance, Compatibility::new));

        public Compatibility(ResourceKey<Level> enhancedCelestialsMoonDimension, ResourceKey<Level> lunarMoonDimension) {
            this.enhancedCelestialsMoonDimension = enhancedCelestialsMoonDimension;
            this.lunarMoonDimension = lunarMoonDimension;
        }

        public ResourceKey<Level> getEnhancedCelestialsMoonDimension() {
            return this.enhancedCelestialsMoonDimension;
        }

        public ResourceKey<Level> getLunarMoonDimension() {
            return this.lunarMoonDimension;
        }
    }
}

