/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.povstalec.stellarview.api.common.space_objects.OrbitingObject;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.StarLike;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;

public abstract class GravityLense
extends StarLike {
    public static final String LENSING_INTENSITY = "lensing_intensity";
    public static final String MAX_LENSING_DISTANCE = "max_lensing_distance";
    protected float lensingIntensity;
    protected double maxLensingDistance;

    public GravityLense() {
    }

    public GravityLense(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, Optional<OrbitingObject.OrbitInfo> orbitInfo, List<TextureLayer> textureLayers, TexturedObject.FadeOutHandler fadeOutHandler, float minStarSize, float maxStarAlpha, float minStarAlpha, float lensingIntensity, double maxLensingDistance) {
        super(parent, coords, axisRotation, orbitInfo, textureLayers, fadeOutHandler, minStarSize, maxStarAlpha, minStarAlpha);
        this.lensingIntensity = lensingIntensity;
        this.maxLensingDistance = maxLensingDistance;
    }

    public float getLensingIntensity() {
        return this.lensingIntensity;
    }

    public double getMaxLensingDistance() {
        return this.maxLensingDistance;
    }

    public double getLensingIntensity(double distance) {
        double lensingIntensity = this.getLensingIntensity();
        lensingIntensity -= lensingIntensity * (distance / this.maxLensingDistance / 1.0E7);
        return lensingIntensity;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128350_(LENSING_INTENSITY, this.lensingIntensity);
        tag.m_128347_(MAX_LENSING_DISTANCE, this.maxLensingDistance);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.lensingIntensity = tag.m_128457_(LENSING_INTENSITY);
        this.maxLensingDistance = tag.m_128457_(MAX_LENSING_DISTANCE);
    }
}

