/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network2.sync.client;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.ShopHandler;
import net.sixik.sdmshoprework.common.shop.ShopEntry;
import net.sixik.sdmshoprework.common.shop.ShopTab;

public class SendAddEntryS2C
extends BaseS2CMessage {
    private final UUID tabID;
    private final CompoundTag entryNBT;

    public SendAddEntryS2C(UUID tabID, CompoundTag entryNBT) {
        this.tabID = tabID;
        this.entryNBT = entryNBT;
    }

    public SendAddEntryS2C(FriendlyByteBuf buf) {
        this.tabID = buf.m_130259_();
        this.entryNBT = buf.m_130261_();
    }

    public MessageType getType() {
        return null;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.tabID);
        buf.m_130079_(this.entryNBT);
    }

    public void handle(NetworkManager.PacketContext context) {
        Optional<ShopTab> shopTab = ShopHandler.getShopTab(this.tabID, true);
        if (shopTab.isEmpty()) {
            this.sendError("No ShopTab found for id " + this.tabID, new Object[0]);
            return;
        }
        ShopTab tab = shopTab.get();
        Optional<ShopEntry> entryOptional = ShopEntry.create(tab, this.entryNBT);
        if (entryOptional.isEmpty()) {
            return;
        }
        ShopEntry entry = entryOptional.get();
        if (tab.getTabEntry().removeIf(s -> s.entryUUID.equals(entry.entryUUID))) {
            SDMShopRework.LOGGER.info("[CLIENT] Removed old shop entry {}", (Object)(entry.entryUUID + " and created new"));
        }
        tab.getTabEntry().add(entry);
    }

    private void sendError(String error, Object ... args) {
        SDMShopRework.LOGGER.warn(error, args);
        SDMShopRework.LOGGER.warn("[CLIENT] Can't add shop entry: {}", (Object)this.entryNBT);
    }
}

