/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.sync;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.client.screen.basic.AbstractShopScreen;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopEntry;
import net.sixik.sdmshoprework.network.ShopNetwork;

public class SendShopEntryS2C
extends BaseS2CMessage {
    private final CompoundTag nbt;
    private final UUID tabID;
    private final UUID shopUUID;

    public SendShopEntryS2C(AbstractShopEntry entry, UUID shopUUID) {
        this.nbt = entry.serializeNBT();
        this.tabID = entry.getShopTab().shopTabUUID;
        this.shopUUID = shopUUID;
    }

    public SendShopEntryS2C(FriendlyByteBuf bug) {
        this.nbt = bug.m_130261_();
        this.tabID = bug.m_130259_();
        this.shopUUID = bug.m_130259_();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_SHOP_ENTRY;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
        buf.m_130077_(this.tabID);
        buf.m_130077_(this.shopUUID);
    }

    public void handle(NetworkManager.PacketContext context) {
        ShopEntry entry = new ShopEntry(null);
        entry.deserializeNBT(this.nbt);
        AbstractShopEntry d = ShopBase.CLIENT.getShopTab(this.tabID).getShopEntry(entry.entryUUID);
        if (d != null) {
            d.deserializeNBT(this.nbt);
        } else {
            ShopBase.CLIENT.getShopTab(this.tabID).createShopEntry(entry.serializeNBT());
        }
        AbstractShopScreen.refreshIfOpen();
    }
}

