/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.sync;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.ShopHandler;
import net.sixik.sdmshoprework.api.ShopSerializerHandler;
import net.sixik.sdmshoprework.common.shop.MultiShop;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.network.ShopNetwork;
import net.sixik.sdmshoprework.network.sync.SendShopTabS2C;

public class SendGetTabsC2S
extends BaseC2SMessage {
    private final String tabID;
    private final UUID shopUUID;

    public SendGetTabsC2S(UUID shopUUID) {
        this.tabID = "null";
        this.shopUUID = shopUUID;
    }

    public SendGetTabsC2S(String tabID, UUID shopUUID) {
        this.tabID = tabID;
        this.shopUUID = shopUUID;
    }

    public SendGetTabsC2S(FriendlyByteBuf buf) {
        this.tabID = buf.m_130277_();
        this.shopUUID = buf.m_130259_();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_GET_TABS;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.tabID);
        buf.m_130077_(this.shopUUID);
    }

    public void handle(NetworkManager.PacketContext context) {
        Optional<ShopBase> optional = MultiShop.getShop(this.shopUUID);
        if (optional.isEmpty()) {
            return;
        }
        ShopBase base = optional.get();
        if (this.tabID.equals("null")) {
            for (ShopTab shopTab2 : base.getShopTabs()) {
                new SendShopTabS2C(ShopSerializerHandler.serializeShopTab(shopTab2, 3), this.shopUUID).sendTo((ServerPlayer)context.getPlayer());
            }
            SDMShopRework.LOGGER.debug("Send shopTabs: {}", (Object)base.getShopTabs().size());
            return;
        }
        UUID uuid = UUID.fromString(this.tabID);
        Optional<ShopTab> tab = ShopHandler.getShopTab(uuid, false, base);
        tab.ifPresent(shopTab -> {
            new SendShopTabS2C(ShopSerializerHandler.serializeShopTab(shopTab, 3), this.shopUUID).sendTo((ServerPlayer)context.getPlayer());
            SDMShopRework.LOGGER.debug("Send shopTab: {}", (Object)shopTab.shopTabUUID);
        });
    }
}

