/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.sync;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.ShopHandler;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.common.shop.MultiShop;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.network.ShopNetwork;
import net.sixik.sdmshoprework.network.sync.SendShopEntryS2C;

public class SendGetEntriesC2S
extends BaseC2SMessage {
    private final UUID tabUUID;
    private final UUID shopUUID;

    public SendGetEntriesC2S(UUID tabUUID, UUID shopUUID) {
        this.tabUUID = tabUUID;
        this.shopUUID = shopUUID;
    }

    public SendGetEntriesC2S(FriendlyByteBuf bug) {
        this.tabUUID = bug.m_130259_();
        this.shopUUID = bug.m_130259_();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_GET_ENTRIES;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.tabUUID);
        buf.m_130077_(this.shopUUID);
    }

    public void handle(NetworkManager.PacketContext context) {
        Optional<ShopBase> shopOtional = MultiShop.getShop(this.shopUUID);
        if (shopOtional.isEmpty()) {
            return;
        }
        ShopBase shop = shopOtional.get();
        Optional<ShopTab> tabOptional = ShopHandler.getShopTab(this.tabUUID, false, shop);
        if (tabOptional.isEmpty()) {
            SDMShopRework.LOGGER.warn("Shop tab not exists: " + this.tabUUID);
            return;
        }
        ShopTab tab = tabOptional.get();
        for (AbstractShopEntry entry : tab.getTabEntry()) {
            new SendShopEntryS2C(entry, this.shopUUID).sendTo((ServerPlayer)context.getPlayer());
        }
        SDMShopRework.LOGGER.debug("Send shopTabEntries: {}", (Object)tab.getTabEntry().size());
    }
}

