/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.sync;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.network.ShopNetwork;
import net.sixik.sdmshoprework.network.sync.SendGetTabsC2S;

public class SendClearTabsS2C
extends BaseS2CMessage {
    private static final UUID DEFAULT = UUID.fromString("e1967fdb-cb22-4f83-b437-ba1a12f771bb");
    private final UUID tabID;
    private final UUID shopUUID;

    public SendClearTabsS2C() {
        this.tabID = DEFAULT;
        this.shopUUID = ShopBase.SERVER.shopUUID;
    }

    public SendClearTabsS2C(UUID shopUUID) {
        this.tabID = DEFAULT;
        this.shopUUID = shopUUID;
    }

    public SendClearTabsS2C(UUID tabID, UUID shopUUID) {
        this.tabID = tabID;
        this.shopUUID = shopUUID;
    }

    public SendClearTabsS2C(FriendlyByteBuf buf) {
        this.tabID = buf.m_130259_();
        this.shopUUID = buf.m_130259_();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_CLEAR_TAB;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.tabID);
        buf.m_130077_(this.shopUUID);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (this.tabID.equals(DEFAULT)) {
            ShopBase.CLIENT.getShopTabs().clear();
            new SendGetTabsC2S(this.shopUUID).sendToServer();
            return;
        }
        ShopTab tab = ShopBase.CLIENT.getShopTab(this.tabID);
        if (tab == null) {
            return;
        }
        tab.getTabEntry().clear();
        new SendGetTabsC2S(tab.shopTabUUID.toString(), this.shopUUID).sendToServer();
    }
}

