/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.server.move;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.common.utils.ListHelper;
import net.sixik.sdmshoprework.network.ShopNetwork;

public class SendMoveShopEntryC2S
extends BaseC2SMessage {
    private final UUID tabID;
    private final int from;
    private final int to;

    public SendMoveShopEntryC2S(UUID tabID, int from, int to) {
        this.tabID = tabID;
        this.from = from;
        this.to = to;
    }

    public SendMoveShopEntryC2S(FriendlyByteBuf buf) {
        this.tabID = buf.m_130259_();
        this.from = buf.readInt();
        this.to = buf.readInt();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_MOVE_ENTRY;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130077_(this.tabID);
        friendlyByteBuf.writeInt(this.from);
        friendlyByteBuf.writeInt(this.to);
    }

    public void handle(NetworkManager.PacketContext packetContext) {
        try {
            ShopTab shopTab = ShopBase.SERVER.getShopTab(this.tabID);
            ListHelper.swap(shopTab.getTabEntry(), this.from, this.to);
            ShopBase.SERVER.syncShop(packetContext.getPlayer().m_20194_());
            ShopBase.SERVER.saveShopToFile();
        }
        catch (Exception e) {
            SDMShopRework.printStackTrace("", e);
        }
    }
}

