/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.server.edit;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.network.ShopNetwork;

public class SendEditShopEntryC2S
extends BaseC2SMessage {
    private final UUID entryID;
    private final UUID tabID;
    private final CompoundTag nbt;

    public SendEditShopEntryC2S(UUID tabID, UUID entryID, CompoundTag nbt) {
        this.entryID = entryID;
        this.tabID = tabID;
        this.nbt = nbt;
    }

    public SendEditShopEntryC2S(FriendlyByteBuf buf) {
        this.tabID = buf.m_130259_();
        this.entryID = buf.m_130259_();
        this.nbt = buf.m_130261_();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_EDIT_ENTRY;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130077_(this.tabID);
        friendlyByteBuf.m_130077_(this.entryID);
        friendlyByteBuf.m_130079_(this.nbt);
    }

    public void handle(NetworkManager.PacketContext packetContext) {
        try {
            ShopBase.SERVER.getShopTab(this.tabID).getShopEntry(this.entryID).deserializeNBT(this.nbt);
            ShopBase.SERVER.syncShop(packetContext.getPlayer().m_20194_());
            ShopBase.SERVER.saveShopToFile();
        }
        catch (Exception e) {
            SDMShopRework.printStackTrace("", e);
        }
    }
}

